import React from "react";
import IconButton from "@mui/material/IconButton";
import { useTheme } from "../atoms/theme";
import MoonIcon from "@mui/icons-material/Brightness4";
import SunIcon from "@mui/icons-material/Brightness7";

const ThemeSwitch: React.FC = () => {
  const { theme, toggleTheme, mounted } = useTheme();

  if (!mounted) {
    return <IconButton disabled aria-label="Theme switch loading"><SunIcon sx={{ fontSize: 20 }} /></IconButton>; 
  }

  return (
    <IconButton onClick={toggleTheme} aria-label="Toggle theme">
      {theme === "light" ? (
        <SunIcon sx={{ fontSize: 20 }} />
      ) : (
        <MoonIcon sx={{ fontSize: 20 }} />
      )}
    </IconButton>
  );
};

export default ThemeSwitch;
