import React from "react";
import { Button, TextField, Typography } from "@mui/material";
import Link from "next/link";
import HomeFeatureApps from "./homeFeatureApps";
import HomeTrustedBusinesses from "./homeTrustedBusinesses";
import HomeTrustedBy from "./homeTrustedBy";

const HeroSection: React.FC = () => {
  return (
    <>
      <div
        id="home-section"
        style={{ paddingLeft: "4rem" }}
        className="flex flex-col sm:flex-row items-center justify-between min-h-[calc(10vh)] gap-8 mt-15 sm:gap-16 px-4 pr-12 sm:px-8"
      >
        <div className="flex-1 max-w-[600px] flex flex-col gap-6 text-center sm:text-left pt-20 sm:pt-0">
          <Typography
            variant="h3"
            className="hidden mt-4 font-light text-center text-gray-800 sm:flex sm:text-left dark:text-gray-300 pr-32"
            style={{ paddingTop: "1rem", fontSize: "2.5rem" }}
          >
            A Powerful Workspace Software Suite
          </Typography>
          <Typography
            variant="h5"
            className="font-normal text-center text-gray-800 sm:hidden sm:text-left dark:text-gray-300 sm:mt-0 pr-4"
          >
            A Powerful Workspace Software Suite
          </Typography>

          <Typography
            className="hidden font-light text-center text-gray-800 sm:flex sm:text-left dark:text-gray-300"
            style={{ fontSize: "1rem" }}
          >
            Everything you need to run, manage, and grow your
            business—seamlessly. From operations to analytics—simplify, unify,
            and scale. your Success, Powered with AI.{" "}
          </Typography>
          <Typography
            className="font-normal text-center text-gray-800 sm:hidden sm:text-left dark:text-gray-300 sm:mt-0"
            style={{ fontSize: "0.8rem" }}
          >
            Everything you need to run, manage, and grow your
            business—seamlessly. From operations to analytics—simplify, unify,
            and scale. your Success, Powered with AI.{" "}
          </Typography>

          <div className="flex flex-col items-center gap-2 mt-0 sm:flex-row sm:gap-4">
            <TextField
              size="small"
              placeholder="Enter email"
              className="w-full sm:w-auto sm:mb-0 sm:pl-2"
              style={{ marginTop: 12 }}
            />
            <Button
              size="large"
              variant="contained"
              className="w-full -mt-12 sm:w-auto sm:mb-0 sm:pl-2"
            >
              <Link
                href={
                  "https://worksuite.clikkle.com/signup?referralApp=Clikkle%20Website&&?redirectto=https%3A%2F%2Fapps.clikkle.com%2F"
                }
              >
                Get Started
              </Link>
            </Button>
          </div>

          <div className="flex items-center gap-2 justify-center sm:justify-start">
            <p className="text-sm dark:text-white">
              No credit card required.
            </p>
            <Link
              href={
                "https://worksuite.clikkle.com/signup?referralApp=Clikkle%20Website&&?redirectto=https%3A%2F%2Fapps.clikkle.com%2F"
              }
              className="text-sm text-blue-500"
            >
              Sign up at no cost
            </Link>
          </div>

          <div className="mt-0">
            <HomeTrustedBusinesses />
          </div>
        </div>

        <div className="items-center justify-center hidden sm:flex">
          <HomeFeatureApps />
        </div>
      </div>

      <div className="mt-0">
        <HomeTrustedBy />
      </div>
    </>
  );
};

export default HeroSection;
