import React from "react";
import { Box, Typography, useTheme, IconButton } from "@mui/material";
import PeopleOutlineIcon from "@mui/icons-material/PeopleOutline";
import FolderOutlinedIcon from "@mui/icons-material/FolderOutlined";
import WorkOutlineOutlinedIcon from "@mui/icons-material/WorkOutlineOutlined";
import DrawIcon from "@mui/icons-material/Draw";
import ChatOutlinedIcon from "@mui/icons-material/ChatOutlined";
import ChevronRightOutlinedIcon from "@mui/icons-material/ChevronRightOutlined";
import Link from "next/link";
;

const FeaturedApps: React.FC = () => {
  const theme = useTheme();

  const apps = [
    {
      icon: <PeopleOutlineIcon color="primary" />,
      title: "HR",
      description: "Comprehensive HR management system for teams.",
      path: "https://clikkle.com/hr",
    },
    {
      icon: <FolderOutlinedIcon color="secondary" />,
      title: "Files",
      description: "Secure file storage and sharing platform.",
      path: "https://clikkle.com/files",
    },
    {
      icon: <WorkOutlineOutlinedIcon color="warning" />,
      title: "Projects",
      description: "Project management and collaboration tools.",
      path: "https://clikkle.com/projects",
    },
    {
      icon: <DrawIcon color="error" />,
      title: "eSign",
      description: "Secure, Effortless e-Signatures Anywhere.",
      path: "https://clikkle.com/esign",
    },
    {
      icon: <ChatOutlinedIcon color="success" />,
      title: "Chat",
      description: "Real-time team communication platform.",
      path: "https://clikkle.com/chat",
    },
  ];

  return (
    <Box
      style={{ paddingTop: "10px" }}
      sx={{
        width: "100%",
        maxWidth: "md",
        p: 4,
        backgroundColor: "dark",
      }}
    >
      <Typography
        variant="overline"
        sx={{
          display: "block",
          color: "text.secondary",

          fontWeight: "medium",
        }}
      >
        FEATURED APPS
      </Typography>

      <Box sx={{ display: "flex", flexDirection: "column", gap: 0 }}>
        {apps.map((app, index) => (
          <Link href={app.path} key={index} style={{ textDecoration: "none" }}>
            <Box
              sx={{
                display: "flex",
                alignItems: "flex-start",
                gap: 2,

                p: 1,
                borderRadius: 1,
                cursor: "pointer",
                "&:hover": {
                  backgroundColor:
                    theme.palette.mode === "dark" ? "grey.900" : "grey.100",
                },
                transition: theme.transitions.create("background-color", {
                  duration: theme.transitions.duration.shortest,
                }),
              }}
            >
              <Box
                sx={{
                  flexShrink: 0,
                  width: 40,
                  height: 40,
                  borderRadius: 1,
                  display: "flex",
                  alignItems: "center",
                  justifyContent: "center",
                  backgroundColor:
                    theme.palette.mode === "dark" ? "grey.900" : "grey.100",
                }}
              >
                {app.icon}
              </Box>

              <Box sx={{ flex: 1, minWidth: 0 }}>
                <Typography
                  variant="body1"
                  sx={{ fontWeight: "medium", color: "text.primary" }}
                >
                  {app.title}
                </Typography>
                <Typography variant="body2" sx={{ color: "text.secondary" }}>
                  {app.description}
                </Typography>
              </Box>

              <IconButton
                size="small"
                sx={{
                  color: "text.disabled",
                  "&:hover": {
                    color: "text.secondary",
                    backgroundColor: "transparent",
                  },
                }}
              >
                <ChevronRightOutlinedIcon />
              </IconButton>
            </Box>
          </Link>
        ))}
      </Box>

      <Box
        component={Link}
         href="/products/"
        sx={{
          mt: 4,
          display: "flex",
          alignItems: "center",
          justifyContent: "space-between",
          color: "primary.main",
          textDecoration: "none",
          "&:hover": {
            color: "primary.light",
          },
          transition: theme.transitions.create("color", {
            duration: theme.transitions.duration.shortest,
          }),
        }}
      >
        <Typography variant="body2" sx={{ fontWeight: "medium", mb: 2 }}>
          EXPLORE ALL APPS
        </Typography>
        <ChevronRightOutlinedIcon
          fontSize="small"
          style={{ marginRight: "1rem" }}
        />
      </Box>
    </Box>
  );
};

export default FeaturedApps;
