import { useState, useEffect } from "react";
import { usePathname } from "next/navigation";
import Box from "@mui/material/Box";
import AppBar from "@mui/material/AppBar";
import Toolbar from "@mui/material/Toolbar";
import Logs from "@mui/icons-material/Menu";
import IconButton from "@mui/material/IconButton";
import Button from "@mui/material/Button";

import Brand from "./brand";
import SidebarDrawer from "./sidebarDrawer";
import { useTheme } from "../atoms/theme";
import { getEncodedReferrer } from "@/utils/utils";

const Header = () => {
  const pathname = usePathname();
  const { theme } = useTheme();
  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const [isMobileView, setIsMobileView] = useState(window.innerWidth < 600);

  const signInMap: { [key: string]: string } = {
    "/files": "https://files.clikkle.com/login?theme=" + theme + "&referralApp=" + getEncodedReferrer(),
    "/hr": "https://hr.clikkle.com/login?theme=" + theme + "&referralApp=" + getEncodedReferrer(),
    "/projects": "https://projects.clikkle.com/login?theme=" + theme + "&referralApp=" + getEncodedReferrer(),
    "/esign": "https://esign.clikkle.com/login?theme=" + theme + "&referralApp=" + getEncodedReferrer(),
    "/chat": "https://chat.clikkle.com/login?theme=" + theme + "&referralApp=" + getEncodedReferrer(),
    "/campaigns": "https://campaigns.clikkle.com/login?theme=" + theme + "&referralApp=" + getEncodedReferrer(),
    "/host": "https://host.clikkle.com/login?theme=" + theme + "&referralApp=" + getEncodedReferrer(),
    "/mail": "https://mail.clikkle.com/login?theme=" + theme + "&referralApp=" + getEncodedReferrer(),
    "/crew": "https://crew.clikkle.com/login?theme=" + theme + "&referralApp=" + getEncodedReferrer(),
  };

  const signUpMap: { [key: string]: string } = {
    "/files": "https://files.clikkle.com/signup?theme=" + theme + "&referralApp=" + getEncodedReferrer(),
    "/hr": "https://hr.clikkle.com/signup?theme=" + theme + "&referralApp=" + getEncodedReferrer(),
    "/projects": "https://projects.clikkle.com/signup?theme=" + theme + "&referralApp=" + getEncodedReferrer(),
    "/esign": "https://esign.clikkle.com/signup?theme=" + theme + "&referralApp=" + getEncodedReferrer(),
    "/chat": "https://chat.clikkle.com/signup?theme=" + theme + "&referralApp=" + getEncodedReferrer(),
    "/campaigns": "https://campaigns.clikkle.com/signup?theme=" + theme + "&referralApp=" + getEncodedReferrer(),
    "/host": "https://host.clikkle.com/signup?theme=" + theme + "&referralApp=" + getEncodedReferrer(),
    "/mail": "https://mail.clikkle.com/signup?theme=" + theme + "&referralApp=" + getEncodedReferrer(),
    "/crew": "https://crew.clikkle.com/signup?theme=" + theme + "&referralApp=" + getEncodedReferrer(),
  };

  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);

  const updateIsMobileView = () => {
    setIsMobileView(window.innerWidth < 600);
  };

  useEffect(() => {
    window.addEventListener("resize", updateIsMobileView);
    return () => window.removeEventListener("resize", updateIsMobileView);
  }, []);

  const currentPath = pathname;
  const signInUrl =
    (currentPath && signInMap[currentPath]) ||
    "https://worksuite.clikkle.com/login?referralApp=Clikkle%20Website&&";
  const signUpUrl =
    (currentPath && signUpMap[currentPath]) ||
    "https://worksuite.clikkle.com/signup?referralApp=Clikkle%20Website&&";

  return (
    <Box sx={{ flexGrow: 1 }}>
      <AppBar
        position="static"
        style={{
          boxShadow: "none",
          height: "55px",
          background: theme === "dark" ? "#121212" : "#0000",
        }}
      >
        <Toolbar>
          <IconButton
            size="large"
            edge="start"
            color="inherit"
            aria-label="menu"
            onClick={toggleLeftDrawer}
            style={{
              ...(theme === "light" ? { color: "#000000" } : {}),
              height: "20px",
            }}
          >
            <Logs />
          </IconButton>

          <Brand />

          <div
            style={{
              display: "flex",
              alignItems: "center",
              gap: "8px",
              minWidth: "fit-content",
            }}
          >
            <a
              href={signInUrl}
              style={{
                textDecoration: "none",
                color: "#3b82f6",
                fontSize: isMobileView ? "13px" : "14px",
                fontWeight: "500",
                cursor: "pointer",
                whiteSpace: "nowrap",
                padding: isMobileView ? "6px 8px" : "8px 12px",
                borderRadius: "6px",
                transition: "background-color 0.2s ease",
              }}
              onMouseEnter={(e) =>
                (e.currentTarget.style.backgroundColor =
                  "rgba(59, 130, 246, 0.1)")
              }
              onMouseLeave={(e) =>
                (e.currentTarget.style.backgroundColor = "transparent")
              }
            >
              Sign In
            </a>

            <Button
              variant="outlined"
              className="cursor-pointer"
              size="small"
              component="a"
              href={signUpUrl}
              style={{
                borderColor: "#3b82f6",
                color: "#3b82f6",
                fontSize: "14px",
                fontWeight: "500",
                textTransform: "none",
                borderRadius: "6px",
                padding: "6px 12px",
                whiteSpace: "nowrap",
                minWidth: "fit-content",
                borderWidth: "1px",
                textDecoration: "none",
              }}
              onMouseEnter={(e) =>
                (e.currentTarget.style.backgroundColor =
                  "rgba(59, 130, 246, 0.1)")
              }
              onMouseLeave={(e) =>
                (e.currentTarget.style.backgroundColor = "transparent")
              }
            >
              Sign Up
            </Button>
          </div>
        </Toolbar>
      </AppBar>

      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
    </Box>
  );
};

export default Header;
