import { footerColumns } from "@/constants/footerText";
import Image from "next/image";
import Link from "next/link";
import React from "react";
import { FaArrowRight } from "react-icons/fa";
import { useTheme } from "../atoms/theme";

type FooterType = {
  footerText?: string;
  isWorksuite?: boolean;
  darkLogo?: string;
  lightLogo?: string;
  footerName?: string;
  isClikkle?: boolean;
};

function Footer({
  footerText = "Streamline your Business with our Apps. Effortlessly for every team.",
  isWorksuite = true,
  isClikkle = true,
  darkLogo = "https://cdn.clikkle.com/images/worksuite/2025/Clikkle%20Worksuite%20Blue%20(%20White%20Text).png",
  lightLogo = "https://cdn.clikkle.com/images/worksuite/2025/Clikkle%20Worksuite%20Blue%20(%20Black%20Text).png",
  footerName = "Technology",
}: FooterType) {
  const { theme } = useTheme();
  const isDarkMode = theme === "dark";

  return (
    <>
      <footer className="w-full">
        <footer className="w-full bg-white dark:bg-[#1a1a1a] border-t border-gray-300 dark:border-[#9c989c] pt-6 md:pt-16">
          <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 mx-auto px-4">
            <div className="flex flex-col md:flex-row justify-between gap-12">
              <div className="space-y-12">
                <Link href="/">
                  <div
                    className={`flex items-center justify-start md:w-[245px] w-auto ${
                      isWorksuite && "gap-3"
                    }`}
                  >
                    <Image
                      width={114}
                      height={40}
                      className={`w-[90px] md:w-[114px]`}
                      alt={`Clikkle ${footerName} logo`}
                      src={isDarkMode ? darkLogo : lightLogo}
                    />
                    {isWorksuite && (
                      <p className="text-gray-900 dark:text-white border-l-[1px] border-gray-300 dark:border-[ffffff3a] pl-[10px] text-[9px] md:text-[10px] font-[450] leading-3">
                        The smarter <br /> way to work.
                      </p>
                    )}
                  </div>
                </Link>

                <div className="max-w-[285px] space-y-1 md:space-y-2 mt-[48px]">
                  <h3 className="font-instrument-sans font-medium text-[18px] leading-[20px] tracking-[0em] font-headline-small text-gray-900 dark:text-[#eeeef0]">
                    Get Started For Free
                  </h3>
                  <p className="font-body-medium text-[#51515E] dark:text-[#eeeef0] text-[length:var(--body-medium-font-size)] tracking-[var(--body-medium-letter-spacing)] leading-[var(--body-medium-line-height)]">
                    {footerText}
                  </p>
                </div>
              </div>

              <div className="flex flex-nowrap justify-between gap-y-8 space-x-2 min-[340px]:space-x-5 md:space-x-14 mt-4 text-[10px] min-[360px]:text-xs sm:text-sm overflow-hidden">
                {footerColumns.map((column, index) => (
                  <div key={`column-${index}`} className="flex flex-col gap-5">
                    <h4 className="font-label-medium text-gray-900 dark:text-white text-[length:var(--label-medium-font-size)] tracking-[var(--label-medium-letter-spacing)] leading-[var(--label-medium-line-height)]">
                      {column.title}
                    </h4>
                    <ul className="flex flex-col gap-4">
                      {column.links.map((link, linkIndex) => (
                        <li key={`link-${index}-${linkIndex}`}>
                          <div className="flex items-start gap-3">
                            <Link
                              href={link.url}
                              target={
                                link.url.startsWith("http") ? "_blank" : "_self"
                              }
                              rel={
                                link.url.startsWith("http")
                                  ? "noopener noreferrer"
                                  : undefined
                              }
                              className="font-body-medium text-[#51515E] dark:text-[#d7d7de] text-[length:var(--body-medium-font-size)] tracking-[var(--body-medium-letter-spacing)] leading-[var(--body-medium-line-height)] whitespace-nowrap hover:text-gray-900 dark:hover:text-white transition-colors"
                            >
                              <span className="flex justify-center items-center gap-2">
                                {link.text}{" "}
                                {column.title === "Social" && (
                                  <FaArrowRight className="w-2 h-2 text-[#51515E] dark:text-[#d7d7de]" />
                                )}
                              </span>
                            </Link>
                            {link.isNew && (
                              <div className="hidden md:flex items-center gap-2 ">
                                <div className="relative w-4 h-4">
                                  <div className="relative w-[13px] h-[13px] top-px left-px bg-[#c3e6ff] rounded-[6.67px]">
                                    <div className="relative w-1 h-1 top-[5px] left-[5px] bg-[#286efb] rounded-sm" />
                                  </div>
                                </div>
                                <span className="font-body-medium text-gray-900 dark:text-white text-[length:var(--body-medium-font-size)] tracking-[var(--body-medium-letter-spacing)] leading-[var(--body-medium-line-height)] whitespace-nowrap">
                                  New
                                </span>
                              </div>
                            )}
                          </div>
                        </li>
                      ))}
                    </ul>
                  </div>
                ))}
              </div>
            </div>
          </div>

          <div className="w-full h-10 bg-gray-100 dark:bg-[#141414] mt-12 flex items-center justify-center">
            <p className="font-body-small text-gray-900 dark:text-white text-[length:var(--body-small-font-size)] tracking-[var(--body-small-letter-spacing)] leading-[var(--body-small-line-height)]">
              ©{new Date().getFullYear()} Clikkle All Rights Reserved.
            </p>
          </div>
        </footer>
      </footer>
    </>
  );
}

export default Footer;
