/* eslint-disable @typescript-eslint/no-explicit-any */
"use client";

import { useEffect, useRef } from "react";
import { usePathname } from "next/navigation";

export default function ClikkleChat() {
  const pathname = usePathname();
  const scriptLoaded = useRef(false);

  const wakeUpWidget = () => {
    if (document.readyState !== "loading") {
      window.document.dispatchEvent(
        new Event("DOMContentLoaded", {
          bubbles: true,
          cancelable: true,
        }),
      );
    }

    if (document.readyState === "complete") {
      window.dispatchEvent(
        new Event("load", {
          bubbles: true,
          cancelable: true,
        }),
      );
    }

    window.dispatchEvent(new Event("resize"));
  };
  
  useEffect(() => {
    (window as any).$mychat = (window as any).$mychat || {};
    (window as any).$mychat.config = {
        organizationId: "68759a3aafaea16453c5de48",
        widgetId: "660150a45e31ef6b174750e8",
        socketUrl: "https://chat.clikkle.com:9100",
        apiUrl: "https://chat.clikkle.com:9100",
        name: "Support Chat",
        position: "bottom-right",
        greetingMessage: "Hello! How can we help you?",
        headerColor: "#007bff",
        userMessageColor: "#007bff",
        userMessageTextColor: "#000000",
        agentMessageColor: "#eee",
        agentMessageTextColor: "#222",
        widgetBackgroundColor: "#fff",
        fontFamily: "sans-serif",
        requirePreChatForm: false,
        isOffline: false,
        autoRespondOffline: true,
        offlineAutoResponseMessage: "Thanks for your message! We'll get back to you soon.",
        chatIconUrl: "https://cdn.clikkle.com/images/chat/logo/2023/chat.png",
        startConversationButtonText: "Start a Conversation",
        organizationLogo: "https://chat.clikkle.com:9100/uploads/photo-1759006977242.png"
      };

    if (document.getElementById("clikkle-chat-script")) {
      setTimeout(wakeUpWidget, 500);
      return;
    }

    const script = document.createElement("script");
    script.id = "clikkle-chat-script";
    script.src = "https://chat.clikkle.com/chat-widget.iife.js";
    script.async = true;

    script.onload = () => {
      scriptLoaded.current = true;
      setTimeout(wakeUpWidget, 100);
    };

    document.body.appendChild(script);
  }, [pathname]);

  return null;
}
