"use client";
import Link from "next/link";
import Image from "next/image";
import { FaArrowRight } from "react-icons/fa";
import React from "react";
import arrow1 from "../../public/images/arrow-1.png";
import popImg from "../../public/images/pop-img.png";
import {
  AlertTriangleIcon,
  BarChart2Icon,
  Bell,
  BrainIcon,
  BugIcon,
  CalendarDays,
  CalendarRangeIcon,
  Ellipsis,
  ClipboardCheckIcon,
  ClockIcon,
  DatabaseIcon,
  FileBarChartIcon,
  FileTextIcon,
  GlobeIcon,
  HandshakeIcon,
  HeadphonesIcon,
  KanbanIcon,
  LayersIcon,
  LayoutDashboardIcon,
  LayoutIcon,
  PaletteIcon,
  ProjectorIcon,
  SearchIcon,
  SendIcon,
  Settings2Icon,
  ShieldCheckIcon,
  SparklesIcon,
  TimerIcon,
  UserCogIcon,
  UserIcon,
  Users,
  Workflow,
  WorkflowIcon,
  ArrowDown,
} from "lucide-react";
import { useState } from "react";
import { ArrowUpRightIcon } from "lucide-react";
import { Button } from "../components/button";
import { Card, CardContent, CardHeader } from "../components/card";
import { Separator } from "../components/separator";
import { Switch } from "../components/switch";
import { FaStar } from "react-icons/fa";
import { IoIosArrowBack, IoIosArrowForward } from "react-icons/io";
import { ArrowRightIcon } from "lucide-react";
import BGLine from "../../public/images/BGLine.png";
import ctaimage from "../../public/images/ctaWhite.png";
import ctaBlack from "../../public/images/ctaBlack.png";
import { Logs } from "lucide-react";
import { useEffect, useRef } from "react";
import logosDark from "../../public/images/logosDark.png";
import logosLight from "../../public/images/logosLight.png";
import LeftDark from "../../public/images/LeftDark.png";
import Star from "../../public/images/star.png";
import { BarChart3Icon, UsersIcon } from "lucide-react";
import { useTheme } from "../atoms/theme";
import { MacWindowCarousel } from "@/components/MacWindowCarousel";
import ThemeSwitch from "../components/themeSwitch";
import ShadowVector from "../../public/images/vectorshadow.png";
import illustration from "../../public/images/project-manager-4439353-3726924.webp";
import SidebarDrawer from "../components/sidebarDrawer";
import AfterHeroSection from "../../public/images/user4.jpeg";
import hrdark from "../../public/images/hrdark.png";
import hrlight from "../../public/images/hrlight.png";
import wsj from "../../public/images/she.avif";
import hr1 from "../../public/images/hr1.png";
import hr3 from "../../public/images/hr3.png";
import hr4 from "../../public/images/hr4.png";
import hr5 from "../../public/images/hr5.png";
import { apps } from "../constants/products";
import AppsSection from "../components/appsSection";
import { footerColumns } from "../constants/footerText";
import AnnouncementBar from "../components/AnnouncementBar";
import { getCookie } from "../utils/cookies";
import Footer from "@/components/Footer";
import rightArrow from "../../public/images/right-arrow.png";
import user5 from "../../public/images/user5.jpeg";
import user6 from "../../public/images/user6.jpeg";
import user9 from "../../public/images/user9.jpeg";
import user7 from "../../public/images/user7.jpeg";
import user8 from "../../public/images/user8.jpeg";
import user1 from "../../public/images/user1.jpeg";
import user3 from "../../public/images/user3.jpeg";
import user4 from "../../public/images/user4.jpeg";
import someee from "../../public/images/someee.jpeg";
import TabbedFeature from "../components/TabbedFeature";
import { BsGridFill } from "react-icons/bs";
import { PiHandshakeFill, PiFiles } from "react-icons/pi";
import {
  IoBriefcaseOutline,
  IoCalendarOutline,
  IoHeartCircle,
} from "react-icons/io5";
import { FaUmbrellaBeach, FaIdCard } from "react-icons/fa";
import { IoMdAlarm } from "react-icons/io";
import { HiOutlineSpeakerWave, HiOutlineDocumentText } from "react-icons/hi2";
import { TbCreditCard } from "react-icons/tb";
import {
  MdDataSaverOff,
  MdOutlineBarChart,
  MdOutlineFlightTakeoff,
  MdOutlineTask,
} from "react-icons/md";

import hrDashboardDay from "../../public/images/HRMS/hrms app-dashboard-daymode.png";
import hrDashboardDark from "../../public/images/HRMS/hrms app-dashboard-darkmode.png";
import hrRecruitDocsDay from "../../public/images/HRMS/hrms app-recruit-recruitment docs-daymode.png";
import hrRecruitDocsDark from "../../public/images/HRMS/hrms app-recruit-recruitment docs-darkmode.png";
import hrJobListingsDay from "../../public/images/HRMS/hrms app-recruit-job listings-daymode.png";
import hrJobListingsDark from "../../public/images/HRMS/hrms app-recruit-job listings-darkmode.png";
import hrLeaveDay from "../../public/images/HRMS/hrms app-leave tracker-leave request-daymode.png";
import hrLeaveDark from "../../public/images/HRMS/hrms app-leave tracker-leave request-darkmode.png";
import hrShiftsDay from "../../public/images/HRMS/hrms app-schedule-employee shifts-daymode.png";
import hrShiftsDark from "../../public/images/HRMS/hrms app-schedule-employee shifts-darkmode.png";
import hrNotifyDay from "../../public/images/HRMS/hrms app-settings-notifications-daymode.png";
import hrNotifyDark from "../../public/images/HRMS/hrms app-settings-notifications-darkmode.png";
import hrOrgListDay from "../../public/images/HRMS/hrms app-org list-daymode.png";
import hrOrgListDark from "../../public/images/HRMS/hrms app-org list-darkmode.png";
import hrOperationsDay from "../../public/images/HRMS/hrms app-operations-daymode.png";
import hrOperationsDark from "../../public/images/HRMS/hrms app-operations-darkmode.png";
import FeaturedPic from "@/components/FeaturedPic";
import { getEncodedReferrer } from "@/utils/utils";
import ClikkleLogo from "@/components/ClikkleLogo";

const HrHome: React.FC = () => {
  const { theme } = useTheme();
  const [scrolled, setScrolled] = useState(false);
  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 0);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);

  const tabFeatures = [
    {
      id: "home",
      label: "Home",
      icon: <BsGridFill className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/operations-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/operations-darkmode.png",
    },
    {
      id: "onboarding",
      label: "Onboarding",
      icon: <PiHandshakeFill className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/onboarding%20candidate-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/onboarding%20candidate-darkmode.png",
    },
    {
      id: "recruiter",
      label: "Recruiter",
      icon: <IoBriefcaseOutline className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/add%20onboarding%20candidate-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/add%20onboarding%20candidate-darkmode.png",
    },
    {
      id: "leave-tracker",
      label: "Leave Tracker",
      icon: <FaUmbrellaBeach className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/permission%20view-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/permission%20view-darkmode.png",
    },
    {
      id: "announcement",
      label: "Announcement",
      icon: <HiOutlineSpeakerWave className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/my%20space%20announements-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/my%20space%20announements-darkmode.png",
    },
    {
      id: "staff",
      label: "Staff",
      icon: <Users className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/staff-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/staff-darkmode.png",
    },
    {
      id: "payroll",
      label: "Payroll",
      icon: <TbCreditCard className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/operations-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/operations-darkmode.png",
    },
    {
      id: "operations",
      label: "Operations",
      icon: <MdDataSaverOff className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/operations-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/operations-darkmode.png",
    },
    {
      id: "files",
      label: "Files",
      icon: <PiFiles className="w-4 h-4" />,
      lightImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/organization%20wide%20files-daymode.png",
      darkImage:
        "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/organization%20wide%20files-darkmode.png",
    },
  ];

  const features1 = [
    {
      icon: (
        <ClipboardCheckIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Employee Records",
      description: "Centralize personnel data securely in one place.",
    },
    {
      icon: <UsersIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Recruitment",
      description: "Streamline hiring with applicant tracking.",
    },
    {
      icon: (
        <FileTextIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Onboarding",
      description: "Automate new hire processes efficiently.",
    },
    {
      icon: (
        <SparklesIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "AI Assistance",
      description: "Smart recommendations for HR decisions.",
    },
  ];
  const features2 = [
    {
      icon: (
        <LayoutDashboardIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Performance Reviews",
      description: "Conduct structured employee evaluations.",
    },
    {
      icon: <BrainIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "HR Analytics",
      description: "Data-driven insights for workforce optimization.",
    },
    {
      icon: (
        <BarChart2Icon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Compliance",
      description: "Track regulatory requirements effortlessly.",
    },
    {
      icon: (
        <KanbanIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Workflows",
      description: "Automate approvals and HR processes.",
    },
  ];

  const features3 = [
    {
      icon: <BugIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Time Tracking",
      description: "Monitor attendance and working hours.",
    },
    {
      icon: (
        <AlertTriangleIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Leave Management",
      description: "Handle PTO requests and approvals.",
    },
    {
      icon: (
        <SearchIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Candidate Search",
      description: "Find talent with AI-powered matching.",
    },
    {
      icon: (
        <WorkflowIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Payroll Integration",
      description: "Sync with payroll systems seamlessly.",
    },
  ];

  const features4 = [
    {
      icon: (
        <Settings2Icon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Custom Workflows",
      description: "Tailor HR processes to your needs.",
    },
    {
      icon: (
        <BarChart3Icon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Reporting",
      description: "Generate custom HR analytics reports.",
    },
    {
      icon: <ClockIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />,
      title: "Scheduling",
      description: "Manage employee shifts and rotations.",
    },
    {
      icon: (
        <FileBarChartIcon className="w-6 h-6 text-gray-600 dark:text-[#d7d7de]" />
      ),
      title: "Employee Engagement",
      description: "Measure and improve satisfaction.",
    },
  ];
  const [productsOpen, setProductsOpen] = useState(false);
  const productsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (
        productsRef.current &&
        !productsRef.current.contains(event.target as Node)
      ) {
        setProductsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);

  const testimonials = [
    {
      text: "This HR platform has revolutionized our people operations. The intuitive interface and comprehensive features save us hours weekly. HR efficiency is up 45% since implementation. Essential for modern HR teams.",
      name: "Olivia Bennett",
      title: "HR Director at VisionTrack",
      date: "Jul 5, 2025",
      logo: user5,
      recommendNote: "Clikkle HR is highly recommended",
    },
    {
      text: "We've reduced onboarding time by 60% with Clikkle's automated workflows. Applicant tracking and document management keep everything organized. Mobile access enables remote HR management.",
      name: "Ethan Roberts",
      title: "Talent Manager at ApexFlow",
      date: "Jun 20, 2025",
      logo: user6,
      recommendNote: "Essential for talent acquisition",
    },
    {
      text: "Clikkle makes HR administration effortless. Our team spends less time on paperwork and more on strategic initiatives. Compliance tracking and reporting provide invaluable peace of mind.",
      name: "Maya Chen",
      title: "Head of People at NextWave",
      date: "May 30, 2025",
      logo: user7,
      recommendNote: "A game-changer for HR operations",
    },
    {
      text: "Thanks to Clikkle, onboarding new hires is streamlined and consistent. Automated workflows ensure compliance and completion. New employees feel welcomed and prepared from day one.",
      name: "Lucas Grant",
      title: "HR Manager at GrowthEdge",
      date: "Apr 18, 2025",
      logo: user8,
      recommendNote: "Perfect for scaling organizations",
    },
    {
      text: "We're resolving employee issues twice as fast since adopting Clikkle. The centralized employee database and analytics build actionable insights. Transformed our employee experience entirely.",
      name: "Sofia Ramirez",
      title: "People Ops Director at BuildSphere",
      date: "Mar 8, 2025",
      logo: user9,
      recommendNote: "Best HRIS for employee experience",
    },
  ];

  const [idx, setIdx] = useState(0);
  const { text, name, title, date, logo, recommendNote } = testimonials[idx];

  const prev = () =>
    setIdx((idx - 1 + testimonials.length) % testimonials.length);
  const next = () => setIdx((idx + 1) % testimonials.length);

  const [isAnnual, setIsAnnual] = useState(true);

  const monthlyPlans = [
    {
      name: "Private",
      description: "HR Essentials\nPerfect For Small Businesses",
      price: "$20",
      buttonText: "Start With Private",
      buttonVariant: "outline",
      features: [
        { icon: UserIcon, text: "", subtext: "Unlimited Users" },
        { icon: ShieldCheckIcon, text: "", subtext: "All Features Included" },
        { icon: LayoutIcon, text: "", subtext: "Full HR Platform" },
        { icon: SearchIcon, text: "", subtext: "Recruiting / ATS" },
        { icon: CalendarRangeIcon, text: "", subtext: "Time Off Management" },
        { icon: BarChart3Icon, text: "", subtext: "HR Analytics" },
        { icon: ClockIcon, text: "", subtext: "Time & Attendance Tracking" },
        { icon: BrainIcon, text: "", subtext: "Performance Management" },
        { icon: HandshakeIcon, text: "", subtext: "New Hire Onboarding" },
        { icon: SendIcon, text: "", subtext: "Job Offers" },
        { icon: ClipboardCheckIcon, text: "", subtext: "Surveys & Training" },
        { icon: HeadphonesIcon, text: "", subtext: "24/7 Customer Support" },
      ],
      highlighted: false,
    },
    {
      name: "Business",
      description: "Advanced HR\nBest For Growing Companies",
      price: "$30",
      buttonText: "Start With Business",
      buttonVariant: "primary",
      features: [
        { icon: UserIcon, text: "", subtext: "Unlimited Users" },
        { icon: ShieldCheckIcon, text: "", subtext: "All Features Included" },
        { icon: LayoutIcon, text: "", subtext: "Full HR Platform" },
        { icon: SearchIcon, text: "", subtext: "Recruiting / ATS" },
        { icon: CalendarRangeIcon, text: "", subtext: "Time Off Management" },
        { icon: BarChart3Icon, text: "", subtext: "HR Analytics" },
        { icon: ClockIcon, text: "", subtext: "Time & Attendance Tracking" },
        { icon: BrainIcon, text: "", subtext: "Performance Management" },
        { icon: HandshakeIcon, text: "", subtext: "New Hire Onboarding" },
        { icon: SendIcon, text: "", subtext: "Job Offers" },
        { icon: ClipboardCheckIcon, text: "", subtext: "Surveys & Training" },
        { icon: HeadphonesIcon, text: "", subtext: "24/7 Customer Support" },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Enterprise",
      description: "Complete HR Suite\nAll-in-one Solution",
      price: "$40",
      buttonText: "Start With Enterprise",
      buttonVariant: "outline",
      features: [
        { icon: UserIcon, text: "", subtext: "Unlimited Users" },
        { icon: LayersIcon, text: "", subtext: "All Previous Plan Features" },
        {
          icon: GlobeIcon,
          text: "",
          subtext: "Access to All Clikkle Products",
        },
        {
          icon: FileBarChartIcon,
          text: "",
          subtext: "Custom Reports & Analytics",
        },
        { icon: Bell, text: "", subtext: "Real-time Notifications" },
        { icon: DatabaseIcon, text: "", subtext: "Document Management" },
        { icon: PaletteIcon, text: "", subtext: "Mobile App Access" },
        { icon: TimerIcon, text: "", subtext: "Automated Payroll" },
        { icon: UserCogIcon, text: "", subtext: "Employee Self-Service" },
        { icon: BrainIcon, text: "", subtext: "AI Candidate Matching" },
        { icon: ProjectorIcon, text: "", subtext: "Video Interviewing" },
        { icon: KanbanIcon, text: "", subtext: "Project Management Tools" },
      ],
      highlighted: false,
    },
  ];

  const annualPlans = [
    {
      name: "Private",
      description: "HR Essentials\nPerfect For Small Businesses",
      price: "$12",
      buttonText: "Start With Private",
      buttonVariant: "outline",
      features: [
        { icon: UserIcon, text: "", subtext: "Unlimited Users" },
        { icon: ShieldCheckIcon, text: "", subtext: "All Features Included" },
        { icon: LayoutIcon, text: "", subtext: "Full HR Platform" },
        { icon: SearchIcon, text: "", subtext: "Recruiting / ATS" },
        { icon: CalendarRangeIcon, text: "", subtext: "Time Off Management" },
        { icon: BarChart3Icon, text: "", subtext: "HR Analytics" },
        { icon: ClockIcon, text: "", subtext: "Time & Attendance Tracking" },
        { icon: BrainIcon, text: "", subtext: "Performance Management" },
        { icon: HandshakeIcon, text: "", subtext: "New Hire Onboarding" },
        { icon: SendIcon, text: "", subtext: "Job Offers" },
        { icon: ClipboardCheckIcon, text: "", subtext: "Surveys & Training" },
        { icon: HeadphonesIcon, text: "", subtext: "24/7 Customer Support" },
      ],
      highlighted: false,
    },
    {
      name: "Business",
      description: "Advanced HR\nBest For Growing Companies",
      price: "$18",
      buttonText: "Start With Business",
      buttonVariant: "primary",
      features: [
        { icon: UserIcon, text: "", subtext: "Unlimited Users" },
        { icon: ShieldCheckIcon, text: "", subtext: "All Features Included" },
        { icon: LayoutIcon, text: "", subtext: "Full HR Platform" },
        { icon: SearchIcon, text: "", subtext: "Recruiting / ATS" },
        { icon: CalendarRangeIcon, text: "", subtext: "Time Off Management" },
        { icon: BarChart3Icon, text: "", subtext: "HR Analytics" },
        { icon: ClockIcon, text: "", subtext: "Time & Attendance Tracking" },
        { icon: BrainIcon, text: "", subtext: "Performance Management" },
        { icon: HandshakeIcon, text: "", subtext: "New Hire Onboarding" },
        { icon: SendIcon, text: "", subtext: "Job Offers" },
        { icon: ClipboardCheckIcon, text: "", subtext: "Surveys & Training" },
        { icon: HeadphonesIcon, text: "", subtext: "24/7 Customer Support" },
      ],
      highlighted: true,
      backgroundImage: true,
    },
    {
      name: "Enterprise",
      description: "Complete HR Suite\nAll-in-one Solution",
      price: "$24",
      buttonText: "Start With Enterprise",
      buttonVariant: "outline",
      features: [
        { icon: UserIcon, text: "", subtext: "Unlimited Users" },
        { icon: LayersIcon, text: "", subtext: "All Previous Plan Features" },
        {
          icon: GlobeIcon,
          text: "",
          subtext: "Access to All Clikkle Products",
        },
        {
          icon: FileBarChartIcon,
          text: "",
          subtext: "Custom Reports & Analytics",
        },
        { icon: Bell, text: "", subtext: "Real-time Notifications" },
        { icon: DatabaseIcon, text: "", subtext: "Document Management" },
        { icon: PaletteIcon, text: "", subtext: "Mobile App Access" },
        { icon: TimerIcon, text: "", subtext: "Automated Payroll" },
        { icon: UserCogIcon, text: "", subtext: "Employee Self-Service" },
        { icon: BrainIcon, text: "", subtext: "AI Candidate Matching" },
        { icon: ProjectorIcon, text: "", subtext: "Video Interviewing" },
        { icon: KanbanIcon, text: "", subtext: "Project Management Tools" },
      ],
      highlighted: false,
    },
  ];

  const [openFAQ, setOpenFAQ] = useState<number | null>(0);

  const faqs = [
    {
      question: "How do I implement HR software?",
      answer: `Getting started is simple! Sign up for your free account, and you'll have access to our HR implementation guide and tutorial videos. Our support team is also available to help you configure your HR workflows.`,
    },
    {
      question: "Can I integrate with payroll systems?",
      answer:
        "Yes, Clikkle HR integrates seamlessly with major payroll providers. Our automated sync ensures accurate data transfer between HR and payroll systems, reducing manual entry errors.",
    },
    {
      question: "How secure is employee data?",
      answer:
        "We prioritize data security with enterprise-grade encryption, regular audits, and compliance certifications. Employee information is protected with strict access controls and permission settings.",
    },
    {
      question: "Can I customize HR workflows?",
      answer:
        "Absolutely! Our platform offers flexible workflow customization for approvals, onboarding sequences, performance reviews, and more. Tailor processes to match your company's unique requirements.",
    },
    {
      question: "Is mobile access available?",
      answer:
        "Yes, our mobile app provides full HR functionality for employees and managers. Access payslips, request time off, approve requests, and manage teams from anywhere.",
    },
  ];

  const isDarkMode = theme === "dark";

  const [dotsOpen, setDotsOpen] = useState(false);
  const dotsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (dotsRef.current && !dotsRef.current.contains(event.target as Node)) {
        setDotsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);
  const redirectToSignup = (planName: string, cycle: "monthly" | "annual") => {
    const base = "https://hr.clikkle.com/signup";
    const params = new URLSearchParams({
      theme: theme ?? "",
      plan: planName,
      cycle,
    });
    window.location.replace(`${base}?${params.toString()}`);
  };
  const [announcementOpen, setAnnouncementOpen] = useState(false);

  useEffect(() => {
    const checkHeight = () => {
      const el = document.querySelector("[data-announcement]") as HTMLElement;
      if (el && el.offsetHeight > 0) {
        setAnnouncementOpen(true);
      } else {
        setAnnouncementOpen(false);
      }
    };
    checkHeight();
    const observer = new MutationObserver(checkHeight);
    observer.observe(document.body, { childList: true, subtree: true });
    return () => observer.disconnect();
  }, []);

  useEffect(() => {
    const checkDismissedAnnouncements = () => {
      const dismissed = getCookie("dismissedAnnouncements");
      if (dismissed) {
        try {
          const dismissedIds = JSON.parse(dismissed);
          if (dismissedIds.length > 0) {
            setAnnouncementOpen(false);
          }
        } catch (error) {
          console.error("Error parsing dismissed announcements:", error);
        }
      }
    };

    checkDismissedAnnouncements();

    const interval = setInterval(checkDismissedAnnouncements, 1000);

    return () => clearInterval(interval);
  }, []);
  return (
    <div className="bg-white dark:bg-[#1a1a1a] flex flex-col items-center w-full min-h-screen">
      <div className="w-full max-w-[1540px] relative mx-auto flex flex-col items-center justify-center">
        <section className="w-full">
          <section className="relative w-full  md:min-h-[1038px]  overflow-hidden">
            <div
              className={`fixed top-0 inset-x-0 z-50 ${scrolled
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1a1a]/90"
                  : productsOpen || dotsOpen
                    ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1a1a]/90"
                    : ""
                }`}
            >
              <div
                ref={(el) => {
                  if (el) {
                    const height = el.getBoundingClientRect().height;

                    if (height !== 0) {
                      setAnnouncementOpen(true);
                    }
                  }
                }}
              >
                <AnnouncementBar onClose={() => setAnnouncementOpen(false)} />
              </div>
              <div className="container max-w-[1233px] mx-auto max-[1300px]:px-14 max-[1100px]:px-4">
                <nav
                  className={`relative flex items-center justify-between py-4`}
                >
                  <ClikkleLogo />

                  <div className="flex md:hidden items-center">
                    <div
                      className="flex items-center gap-0 rounded-xl border border-gray-300 dark:border-[#ffffff3a] p-[8px] shadow-sm"
                      onClick={toggleLeftDrawer}
                    >
                      <p className="text-sm font-medium text-gray-900 dark:text-white">
                        <Logs className="w-5 h-5 text-gray-900 dark:text-white mr-3" />
                      </p>

                      <p className="flex items-center  rounded-xl text-sm font-bold ">
                        Menu
                      </p>
                    </div>
                  </div>

                  <div className="hidden md:flex items-center gap-12  font-inter font-medium text-[18px]">
                    <Link
                      href="#features"
                      className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                    >
                      Features
                    </Link>
                    <Link
                      href="#pricing"
                      className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                    >
                      Pricing
                    </Link>
                    <Link
                      href="/blogs"
                      className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                    >
                      Blog
                    </Link>
                    <div className="flex flex-row justify-center items-center">
                      <div className="relative" ref={productsRef}>
                        <button
                          onClick={() => setProductsOpen((o) => !o)}
                          className="cursor-pointer flex items-center gap-1 text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                        >
                          Products
                        </button>
                        {productsOpen && (
                          <div
                            className={`fixed ${announcementOpen ? "top-[115px]" : "top-[75px]"
                              }  
              left-1/2 transform -translate-x-1/2 w-full bg-white/90 dark:bg-[#1a1a1a]/90 backdrop-blur-md 
              shadow-lg p-6 border-b-2 border-gray-300 dark:border-[#575662] z-50 flex justify-center items-center pb-0`}
                          >
                            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                              <div className="flex flex-col gap-3">
                                {apps
                                  .slice(0, Math.ceil(apps.length / 2))
                                  .map((product) => (
                                    <Link
                                      key={product.id}
                                      href={product.route}
                                      className="flex items-center gap-4 p-[0.35rem] rounded-lg hover:bg-gray-100 dark:hover:bg-white/10 transition"
                                    >
                                      <div>
                                        <Image
                                          src={product.image}
                                          alt={product.title}
                                          className="w-[26px]"
                                          width={26}
                                          height={26}
                                        />
                                      </div>
                                      <div>
                                        <p className="font-bold text-gray-900 dark:text-white text-sm">
                                          {product.title}
                                        </p>
                                        <p className="text-xs text-gray-600 dark:text-gray-300">
                                          {product.description}
                                        </p>
                                      </div>
                                    </Link>
                                  ))}
                              </div>

                              <div className="flex flex-col gap-3">
                                {apps
                                  .slice(
                                    Math.ceil(apps.length / 2),
                                    Math.ceil(apps.length / 2) + 2,
                                  )
                                  .map((product) => (
                                    <Link
                                      key={product.id}
                                      href={product.route}
                                      className="flex items-center gap-4 p-[0.35rem] rounded-lg hover:bg-gray-100 dark:hover:bg-white/10 transition"
                                    >
                                      <div>
                                        <Image
                                          src={product.image}
                                          alt={product.title}
                                          className="w-[26px]"
                                          width={26}
                                          height={26}
                                        />
                                      </div>
                                      <div>
                                        <p className="font-bold text-gray-900 dark:text-white text-sm">
                                          {product.title}
                                        </p>
                                        <p className="text-xs text-gray-600 dark:text-gray-300">
                                          {product.description}
                                        </p>
                                      </div>
                                    </Link>
                                  ))}
                                <Link href="/products">
                                  <Button
                                    style={{ marginTop: "5px" }}
                                    variant="ghost"
                                    className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                  >
                                    View all products
                                    <ArrowRightIcon className="h-2 w-2 dark:text-white" />
                                  </Button>
                                </Link>
                              </div>
                              <div className="hidden lg:flex flex-row items-center justify-center text-center gap-3">
                                <Image
                                  src={illustration}
                                  alt="Illustration"
                                  className="w-auto h-[175px]"
                                  width={300}
                                  height={175}
                                />
                                <div className="flex flex-col justify-center items-center h-full">
                                  <p className="text-sm text-gray-700 dark:text-gray-300 max-w-[200px] pb-5">
                                    Get started today the modern solution to
                                    power your business.
                                  </p>
                                  <Button
                                    variant="ghost"
                                    onClick={() => {
                                      window.location.replace(
                                        "https://hr.clikkle.com/signup?theme=" +
                                        theme +
                                        "&referralApp=" +
                                        getEncodedReferrer(),
                                      );
                                    }}
                                    className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                  >
                                    Get Started Today
                                    <ArrowRightIcon
                                      className={`h-2 w-2 dark:text-white`}
                                    />
                                  </Button>
                                </div>
                              </div>
                            </div>
                          </div>
                        )}
                      </div>

                      <div className="relative" ref={dotsRef}>
                        <Ellipsis
                          onClick={() => setDotsOpen((o) => !o)}
                          className="w-8 h-6 rounded-full p-[1px] cursor-pointer"
                        />
                        {dotsOpen && (
                          <div
                            className={`fixed ${announcementOpen ? "top-[115px]" : "top-[75px]"
                              }  left-1/2 transform -translate-x-1/2 w-full 
    bg-white/90 dark:bg-[#1a1a1a]/90 backdrop-blur-md 
    shadow-lg border-b-2 border-gray-300 dark:border-[#575662] 
    z-50 flex justify-center`}
                          >
                            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 py-6">
                              <div className="flex flex-col md:flex-row justify-between items-start gap-12">
                                <div className="space-y-12">
                                  <div className="max-w-[285px] space-y-2 mb-0">
                                    <h3 className="font-instrument-sans font-medium text-[18px] leading-[20px] text-gray-900 dark:text-[#eeeef0]">
                                      Get Started For Free
                                    </h3>
                                    <p className="font-body-medium text-[#51515E] dark:text-[#eeeef0]">
                                      Streamline your Business with our Apps.
                                      Effortlessly for every team.
                                    </p>
                                  </div>
                                  <Button
                                    style={{ marginTop: "20px" }}
                                    variant="ghost"
                                    onClick={() => {
                                      window.location.replace(
                                        "https://hr.clikkle.com/signup?theme=" +
                                        theme +
                                        "&referralApp=" +
                                        getEncodedReferrer(),
                                      );
                                    }}
                                    className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                  >
                                    See How It Works
                                    <ArrowRightIcon
                                      className={`h-2 w-2 dark:text-white`}
                                    />
                                  </Button>
                                </div>

                                <div className="flex flex-wrap gap-x-14 gap-y-8 text-xs sm:text-sm">
                                  {footerColumns.map((column, index) => (
                                    <div
                                      key={index}
                                      className="flex flex-col gap-5"
                                    >
                                      <h4 className="font-label-medium text-gray-900 dark:text-white">
                                        {column.title}
                                      </h4>
                                      <ul className="flex flex-col gap-4">
                                        {column.links.map((link, linkIndex) => (
                                          <li key={linkIndex}>
                                            <div className="flex items-start gap-3">
                                              <Link
                                                href={link.url}
                                                target={
                                                  link.url.startsWith("http")
                                                    ? "_blank"
                                                    : "_self"
                                                }
                                                rel={
                                                  link.url.startsWith("http")
                                                    ? "noopener noreferrer"
                                                    : undefined
                                                }
                                                className="font-body-medium text-[#51515E] dark:text-[#d7d7de] hover:text-gray-900 dark:hover:text-white transition-colors whitespace-nowrap flex items-center gap-2"
                                              >
                                                {link.text}
                                                {column.title === "Social" && (
                                                  <FaArrowRight className="w-2 h-2" />
                                                )}
                                              </Link>

                                              {link.isNew && (
                                                <div className="hidden md:flex items-center gap-2">
                                                  <div className="w-4 h-4 flex items-center justify-center">
                                                    <div className="w-[13px] h-[13px] bg-[#c3e6ff] rounded-[6.67px] flex items-center justify-center">
                                                      <div className="w-1 h-1 bg-[#286efb] rounded-sm" />
                                                    </div>
                                                  </div>
                                                  <span className="font-body-medium text-gray-900 dark:text-white whitespace-nowrap">
                                                    New
                                                  </span>
                                                </div>
                                              )}
                                            </div>
                                          </li>
                                        ))}
                                      </ul>
                                    </div>
                                  ))}
                                </div>
                              </div>
                            </div>
                          </div>
                        )}
                      </div>
                    </div>
                  </div>

                  <div className="hidden md:flex items-center gap-4">
                    <div className="hidden md:flex items-center gap-4">
                      <div className="w-6">
                        <ThemeSwitch />
                      </div>
                      <div className="flex items-center gap-2 rounded-xl border border-gray-300 dark:border-[#ffffff3a] p-1 shadow-sm">
                        <button
                          className="cursor-pointer px-3 py-1 text-sm font-medium text-gray-900 dark:text-white"
                          onClick={() => {
                            window.location.replace(
                              "https://hr.clikkle.com/login?theme=" +
                              theme +
                              "&referralApp=" +
                              getEncodedReferrer(),
                            );
                          }}
                        >
                          Login
                        </button>

                        <button
                          className="cursor-pointer flex items-center gap-1 rounded-xl bg-[#286efb] hover:bg-[#3367d6] px-4 py-1.5 text-sm font-medium text-white transition"
                          onClick={() => {
                            window.location.replace(
                              "https://hr.clikkle.com/signup?theme=" +
                              theme +
                              "&referralApp=" +
                              getEncodedReferrer(),
                            );
                          }}
                        >
                          Try for free
                          <span>
                            <ArrowRightIcon className="w-4" />
                          </span>
                        </button>
                      </div>
                    </div>
                  </div>
                </nav>
              </div>
            </div>

            <div
              className={`z-10 flex flex-col items-center text-center ${announcementOpen ? "pt-[140px]" : "pt-[110px]"
                } px-6 relative`}
            >
              <div className="absolute h-full w-full top-0 right-0 ">
                <Image
                  src={ShadowVector}
                  alt="Shadow vector"
                  className="w-full h-full"
                  width={100}
                  height={100}
                />
              </div>
              <div className="flex items-center justify-center gap-2 mb-2 font-semibold py-4">
                <Link href="/">
                  <div className="flex items-center justify-center md:w-[245px] w-auto">
                    <Image
                      className="h-[32px] md:h-[40px] w-auto"
                      alt="Clikkle Hr logo"
                      width={114}
                      height={40}
                      src={
                        isDarkMode
                          ? "https://cdn.clikkle.com/images/hr/logo/2025/Clikkle%20HR%20Blue%20(%20White%20Text).png"
                          : "https://cdn.clikkle.com/images/hr/logo/2025/Clikkle%20HR%20Blue%20(%20Black%20Text).png"
                      }
                    />
                  </div>
                </Link>
              </div>
              <h1 className="font-inter font-black text-[40px] lg:text-7xl text-gray-900 dark:text-[#fff] mb-3 md:mb-[0.5rem] max-w-5xl leading-[1.1] md:leading-[1]">
                <span className={`dark:text-[#A9C5FF] text-[#286efb]`}>
                  HR That{" "}
                </span>
                Works <br className="hidden sm:block" />
                Smarter
              </h1>
              <span className="relative font-small text-[14px] md:text-[18px] text-[#3D3D3D] dark:text-[#EEEEF0] mb-8 max-w-3xl ">
                Clikkle HR adapts to workforce changes easily. Flexible{" "}
                <br className="hidden sm:block" /> people-management &
                streamlined HR ops
                {/*<img
                    src={"/images/arrow-1.png"}
                    alt="arrow"
                    className="hidden sm:block absolute right-[-112px] top-[0px] rotate-[330deg]"
                  />*/}
                {/*<div className="absolute right-[-280px] top-[40px] hidden sm:block">
             <p className="text-[#51515E] dark:text-[#d7d7de] text-[24px] font-black font-caveat">
                    $  12.00 / month <br />
                    for Clikkle HR
                  </p>
                </div>*/}
              </span>
              <div className="flex flex-col sm:flex-row items-center !gap-[8px] sm:gap-4 mb-4 w-full max-w-lg z-10">
                <input
                  type="email"
                  placeholder="Enter Your Email"
                  className="flex-1 px-4 py-3 rounded-lg bg-white  text-gray-900  placeholder-gray-500 dark:placeholder-gray-400 focus:outline-none w-full border border-gray-300 dark:border-[#575662] shadow-sm dark:shadow-none"
                />
                <button
                  onClick={() => {
                    window.location.replace(
                      "https://hr.clikkle.com/signup?theme=" +
                      theme +
                      "&referralApp=" +
                      getEncodedReferrer(),
                    );
                  }}
                  type="submit"
                  className="cursor-pointer px-6 py-[14px] bg-[#25272c] dark:bg-[#286efb]  text-white font-medium rounded-lg transition w-full sm:w-auto"
                >
                  Try for Free
                </button>
              </div>{" "}
              <p className="text-[#51515E] dark:text-[#d7d7de] text-sm mb-[0.5rem] z-10">
                No credit card required.{" "}
                <Link
                  href={`${"https://worksuite.clikkle.com/signup?theme=" + theme +
                    "&referralApp=" +
                    getEncodedReferrer()
                    }`}
                  className="text-black dark:text:white dark:text-white underline hover:no-underline hover:cursor-pointer"
                >
                  Sign Up for no cost
                </Link>
              </p>
              <div className="flex flex-col sm:flex-row items-center gap-2 md:gap-16">
                {/*<span className="text-[#51515E] dark:text-[#D7D7DE] text-sm">
                  Trusted by{" "}
                  <span className="dark:text-[#A9C5FF] text-[#286efb]">
                    12K+
                  </span>{" "}
                  companies
                </span>*/}
                <div className="flex items-center gap-8">
                  {/*<Image
                    src={theme === "dark" ? logosDark : logosLight}
                    alt="Logos"
                    className="h-[36px] w-[242px]"
                    width={162}
                    height={36}
                  />*/}
                </div>
              </div>
            </div>
            <div className="flex items-center justify-center pb-8 mt-8 rounded-lg w-full">
              <div className="relative w-full max-w-[1200px]">
                {/*<img
                  src={popImg.src}
                  alt="popImg"
                  className="hidden sm:block absolute w-[120px] left-[-70px] top-[-74px]"
                />*/}
                <MacWindowCarousel initialProduct="hr" />
              </div>
            </div>
            {/* <div className="flex items-center justify-center pb-8 mt-8 rounded-lg w-full md:w-auto">
              <div className="relative w-full flex justify-center">
                <TabbedFeature
                  tabs={tabFeatures}
                  decorator={
                    <Image
                      src={popImg}
                      alt="popImg"
                      className="hidden sm:block absolute w-[120px] left-[-70px] top-[-74px] z-10"
                      width={120}
                      height={120}
                    />
                  }
                />
              </div>
            </div> */}
          </section>
        </section>

        <section className="w-full max-w-[1240px] text-gray-900 dark:text-white py-16 px-4 md:px-8 lg:px-16 m-auto">
          <div className="mx-auto text-center">
            <h2 className="text-sm md:text-base font-semibold text-[#286efb] dark:text-[#adc4fb] mb-4">
              Why Clikkle Hr?
            </h2>

            <h1 className="text-4xl md:text-5xl font-black mb-4 ">
              Automate, optimize, and transform{" "}
              <br className="hidden md:block" /> HR operations
            </h1>

            <p className="text-lg md:text-xl text-gray-600 dark:text-gray-300 mb-12">
              Manage recruitment, performance, compliance, and more
              <br className="hidden md:block" />
              in one unified platform.
            </p>

            <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8 mb-16">
              <div className="flex flex-col items-center">
                <div className="bg-gray-100 dark:bg-[#141414] rounded-2xl p-4 mb-4">
                  <CalendarDays className="w-8 h-8 text-gray-600 dark:text-gray-300" />
                </div>
                <h2 className="text-xl font-semibold mb-2">Recruitment</h2>
                <p className="text-gray-600 dark:text-gray-400 text-center">
                  Streamline hiring from sourcing to onboarding.
                </p>
              </div>

              <div className="flex flex-col items-center">
                <div className="bg-gray-100 dark:bg-[#141414] rounded-2xl p-4 mb-4">
                  <Users className="w-8 h-8 text-gray-600 dark:text-gray-300" />
                </div>
                <h2 className="text-xl font-semibold mb-2">Employee Data</h2>
                <p className="text-gray-600 dark:text-gray-400 text-center">
                  Centralize personnel records securely.
                </p>
              </div>

              <div className="flex flex-col items-center">
                <div className="bg-gray-100 dark:bg-[#141414] rounded-2xl p-4 mb-4">
                  <Bell className="w-8 h-8 text-gray-600 dark:text-gray-300" />
                </div>
                <h2 className="text-xl font-semibold mb-2">Compliance</h2>
                <p className="text-gray-600 dark:text-gray-400 text-center">
                  Stay current with labor regulations.
                </p>
              </div>

              <div className="flex flex-col items-center">
                <div className="bg-gray-100 dark:bg-[#141414] rounded-2xl p-4 mb-4">
                  <Workflow className="w-8 h-8 text-gray-600 dark:text-gray-300" />
                </div>
                <h2 className="text-xl font-semibold mb-2">Automation</h2>
                <p className="text-gray-600 dark:text-gray-400 text-center">
                  Automate HR workflows and approvals.
                </p>
              </div>
            </div>

            <div className="md:mt-36 font-bold border-gray-300 dark:border-[#575662] max-w-[1120px] mx-auto bg-[#20253a] text-white min-h-[35px] dark:bg-[#141414] rounded-2xl p-6 shadow-lg flex flex-col md:flex-row items-center gap-6 overflow-visible relative">
              <Image
                src={AfterHeroSection}
                alt="WSJ"
                className="md:w-[260px] md:h-[330px] w-full h-auto rounded-lg md:object-cover md:ml-[1.7rem] md:mt-[-5.3rem] md:transform md:-rotate-3 md:scale-110 shadow-2xl md:z-20"
                width={260}
                height={330}
              />

              <div className="text-left md:p-[60px]">
                <p className="text-lg md:text-2xl !text-[1.40rem] mb-4 leading-normal">
                  Clikkle HR has transformed our operations since 2020.
                  <br className="hidden sm:block" />
                  <span className="bg-[#3d0ebf] font-semibold">
                    Our HR team saves 15+ hours weekly, and employee
                    satisfaction has increased by 35%.
                  </span>{" "}
                  The platform has become indispensable for our growing
                  organization.
                </p>
                <div className="flex items-center gap-2">
                  <Image
                    src={wsj}
                    alt="peoplefirst Logo"
                    className="w-8 h-8 rounded-sm"
                    width={32}
                    height={32}
                  />
                  <div>
                    <p className="font-semibold">PeopleFirst Inc.</p>
                    <p className="text-sm">HR Director</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-[#1a1a1a]"
            id="features"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
                <div className="space-y-8 justify-self-start">
                  <div className="space-y-4">
                    {" "}
                    <span className="hidden md:block text-[#286efb] dark:text-[#A9C5FF] text-[16px] font-bold">
                      Feature
                    </span>
                    <h2 className="text-[1.6rem] md:text-5xl text-gray-900 mt-4 md:mt-0  dark:text-white !leading-[1.2]  font-inter font-[900]  ">
                      Streamlining
                      <span className="text-[#286efb] dark:text-[#A9C5FF]">
                        {" "}
                        HR processes
                      </span>{" "}
                      for Better
                    </h2>
                    <p className="text-gray-600 dark:text-[#d7d7de] max-w-lg font-inter font-normal text-[16px] md:text-[18px]     ">
                      Clikkle HR streamlines HR tasks with automation, boosting
                      productivity and ensuring compliance.
                    </p>
                  </div>

                  <div className="grid grid-cols-2 gap-6 max-w-[529px]">
                    {features1.map((feature, index) => (
                      <div key={index} className="md:space-y-1">
                        <div className="flex items-center gap-3">
                          <div className="w-4 h-4 rounded-lg flex items-center justify-center text-gray-600 dark:text-[#d7d7de]">
                            {feature.icon}
                          </div>
                          <h3 className="text-gray-900 dark:text-[#d7d7de] text-lg font-open-sauce font-black text-[1.16rem]  ">
                            {feature.title}
                          </h3>
                        </div>
                        <p className="text-gray-600 dark:text-[#d7d7de] text-[14px] leading-[20px] pl-[1.75rem] mt-0 font-inter font-normal">
                          {feature.description}
                        </p>
                      </div>
                    ))}
                  </div>
                  <div className="flex flex-row md:justify-start  gap-4 pt-4">
                    <Button
                      onClick={() => {
                        window.location.replace(
                          "https://hr.clikkle.com/signup?theme=" +
                          theme +
                          "&referralApp=" +
                          getEncodedReferrer(),
                        );
                      }}
                      className="bg-[#286efb] hover:bg-[#3367d6] text-white px-8 py-3 h-[40px]"
                    >
                      Get Started
                    </Button>
                    <div className="pl-4 rounded-lg  font-light md:block hidden text-gray-600 dark:text-[#d7d7de] ">
                      <p className="text-sm leading-relaxed font-inter">
                        <span className="text-[#ff4b5c]">&quot;</span>Managing
                        employee records is effortless now, saving our HR team
                        countless hours!
                        <span className="text-[#ff4b5c]">&quot;</span>
                      </p>
                      <div className="flex items-center gap-3 mt-[0.4rem]">
                        <Image
                          src={user1}
                          alt="Sofia R."
                          className="w-6 h-6 rounded-full"
                          width={24}
                          height={24}
                        />
                        <div>
                          <p className="font-semibold text-sm">Sarah K.</p>
                          <p className="text-xs text-gray-400">HR Manager</p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px]  justify-center md:justify-end order-first lg:order-none">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <FeaturedPic>
                    <Image
                      src={
                        theme === "dark"
                          ? "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/my%20space%20announements-darkmode.png"
                          : "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/my%20space%20announements-daymode.png"
                      }
                      width={600}
                      height={600}
                      alt="Hr picture"
                      className="rounded-lg shadow-lg mt-5 relative z-10  md:min-h-[345px]"
                    />
                  </FeaturedPic>
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-[#1a1a1a]"
            id="features2-2"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center gap-14">
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px]  justify-center md:justify-start order-first lg:order-none gap-2">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <FeaturedPic>
                    <Image
                      src={
                        theme === "dark"
                          ? "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/organization%20wide%20files-darkmode.png"
                          : "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/organization%20wide%20files-daymode.png"
                      }
                      width={600}
                      height={600}
                      alt="Hr picture"
                      className="rounded-lg shadow-lg mt-5 relative z-10  md:min-h-[345px]"
                    />
                  </FeaturedPic>
                </div>
                <div className="space-y-8 flex flex-col items-center md:items-end">
                  <div className="space-y-4">
                    {" "}
                    <span className="hidden md:block text-[#286efb] dark:text-[#A9C5FF] text-[16px] font-bold">
                      Feature
                    </span>
                    <h2 className="text-left  text-[1.6rem] md:text-5xl text-gray-900 mt-4 md:mt-0  dark:text-white !leading-[1.2]  font-inter font-[900]  ">
                      Analyzing & reporting <br className="hidden sm:block" />
                      <span className="text-[#286efb] dark:text-[#A9C5FF]">
                        human resources
                      </span>{" "}
                      data
                    </h2>
                    <p className="text-left text-gray-600 dark:text-[#d7d7de] max-w-lg font-inter font-normal text-[16px] md:text-[18px]     ">
                      Turn HR data into insights to optimize workforce planning,
                      retention, and performance.
                    </p>
                  </div>

                  <div className="grid grid-cols-2 gap-6 max-w-[517px] justify-start items-start ">
                    {features2.map((feature, index) => (
                      <div key={index} className="md:space-y-1">
                        <div className="flex items-center gap-3">
                          <div className="w-4 h-4 rounded-lg flex items-center justify-center text-gray-600 dark:text-[#d7d7de]">
                            {feature.icon}
                          </div>
                          <h3 className="text-gray-900 dark:text-[#d7d7de] text-lg font-open-sauce font-black text-[1.16rem]  ">
                            {feature.title}
                          </h3>
                        </div>
                        <p className="text-gray-600 dark:text-[#d7d7de] text-[14px] leading-[20px] pl-[1.75rem] mt-0 font-inter font-normal">
                          {feature.description}
                        </p>
                      </div>
                    ))}

                    <div className="flex items-start gap-6 pt-4">
                      <div className="flex flex-row sm:flex-row sm:items-center gap-4">
                        <Button
                          onClick={() => {
                            window.location.replace(
                              "https://hr.clikkle.com/signup?theme=" +
                              theme +
                              "&referralApp=" +
                              getEncodedReferrer(),
                            );
                          }}
                          className="bg-[#286efb] hover:bg-[#3367d6] text-white px-8 py-3 h-[40px]"
                          style={{
                            boxShadow: `
          0px 0.25px 0.25px 0px rgba(0,0,0,0.24),
          0px 0.75px 0.75px 0px rgba(0,0,0,0.12),
          0px 1px 1.5px -0.5px rgba(0,0,0,0.12),
          0px 2px 4px -1px rgba(0,0,0,0.12),
          0px 4px 8px -4px rgba(0,0,0,0.12),
          0px 8px 12px -4px rgba(0,0,0,0.06)
        `,
                          }}
                        >
                          Get Started
                        </Button>
                      </div>

                      <div className="pl-4 rounded-lg text-gray-600 dark:text-[#d7d7de] font-light hidden md:block max-w-[280px]">
                        <p className="text-sm leading-relaxed font-inter w-60">
                          <span className="text-[#ff4b5c]">&quot;</span>
                          Our HR analytics have never been more insightful and
                          actionable.
                          <span className="text-[#ff4b5c]">&quot;</span>
                        </p>
                        <div className="flex items-center gap-3 mt-2">
                          <Image
                            alt="User 3"
                            src={user3}
                            className="w-6 h-6 rounded-full"
                            width={24}
                            height={24}
                          />
                          <div>
                            <p className="font-semibold text-sm">James L.</p>
                            <p className="text-xs text-gray-400">HR Analyst</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-[#1a1a1a]"
            id="features3-3"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center sm:gap-[8rem]">
                <div className="space-y-8 justify-self-start">
                  <div className="space-y-4">
                    {" "}
                    <span className="hidden md:block text-[#286efb] dark:text-[#A9C5FF] text-[16px] font-bold">
                      Feature
                    </span>
                    <h2 className="text-[1.6rem] md:text-5xl text-gray-900 mt-4 md:mt-0  dark:text-white !leading-[1.2] font-inter font-[900]">
                      Digital{" "}
                      <span className="text-[#286efb] dark:text-[#A9C5FF]">
                        employee records
                      </span>{" "}
                      cut paper use
                    </h2>
                    <p className="text-gray-600 dark:text-[#d7d7de] max-w-lg font-inter font-normal text-[16px] md:text-[18px]     ">
                      Clikkle HR offers complete talent management to enhance
                      the entire employee journey.
                    </p>
                  </div>

                  <div className="grid grid-cols-2 gap-6 max-w-[529px]">
                    {features3.map((feature, index) => (
                      <div key={index} className="md:space-y-1">
                        <div className="flex items-center gap-3">
                          <div className="w-4 h-4 rounded-lg flex items-center justify-center text-gray-600 dark:text-[#d7d7de]">
                            {feature.icon}
                          </div>
                          <h3 className="text-gray-900 dark:text-[#d7d7de] text-lg font-open-sauce font-black text-[1.16rem]  ">
                            {feature.title}
                          </h3>
                        </div>
                        <p className="text-gray-600 dark:text-[#d7d7de] text-[14px] leading-[20px] pl-[1.75rem] mt-0 font-inter font-normal">
                          {feature.description}
                        </p>
                      </div>
                    ))}
                  </div>
                  <div className="flex flex-row md:justify-start  gap-4 pt-4">
                    <Button
                      onClick={() => {
                        window.location.replace(
                          "https://hr.clikkle.com/signup?theme=" +
                          theme +
                          "&referralApp=" +
                          getEncodedReferrer(),
                        );
                      }}
                      className="bg-[#286efb] hover:bg-[#3367d6] text-white px-8 py-3 h-[40px]"
                    >
                      Get Started
                    </Button>
                    <div className="pl-4 rounded-lg text-gray-600 dark:text-[#d7d7de] font-light md:block hidden">
                      <p className="text-sm leading-relaxed font-inter">
                        <span className="text-[#ff4b5c]">&quot;</span>Our
                        recruitment process is 50% faster with Clikkle&apos;s
                        ATS!
                        <span className="text-[#ff4b5c]">&quot;</span>
                      </p>
                      <div className="flex items-center gap-3 mt-[0.4rem]">
                        <Image
                          src={someee}
                          alt="Batu K."
                          className="w-6 h-6 rounded-full"
                          width={24}
                          height={24}
                        />
                        <div>
                          <p className="font-semibold text-sm">Michael T.</p>
                          <p className="text-xs text-gray-400">
                            Talent Acquisition
                          </p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px]  justify-center md:justify-end order-first lg:order-none">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <FeaturedPic>
                    <Image
                      src={
                        theme === "dark"
                          ? "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/permission%20view-darkmode.png"
                          : "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/permission%20view-daymode.png"
                      }
                      width={600}
                      height={600}
                      alt="Hr picture"
                      className="rounded-lg shadow-lg mt-5 relative z-10  md:min-h-[345px]"
                    />
                  </FeaturedPic>
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <section
            className="w-full md:py-32 p-6 py-20 relative overflow-hidden bg-white dark:bg-[#1a1a1a]"
            id="features4-4"
          >
            <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-0 mx-auto px-0">
              <div className="grid grid-cols-1 lg:grid-cols-2 items-center justify-center gap-14">
                <div className="relative flex items-center h-full md:w-[552px] md:h-[505px]  justify-center md:justify-start order-first lg:order-none gap-2">
                  <div className="absolute w-[380px] h-[380px] rounded-full bg-[radial-gradient(circle,_rgba(0,0,0,0.15)_0%,rgba(31,98,255,0.1)_30%,_rgba(0,0,0,0)_80%)] dark:bg-[radial-gradient(circle,_rgba(255,255,255,0.15)_0%,rgba(165,197,255,0.1)_30%,_rgba(255,255,255,0)_80%)] filter blur-3xl" />
                  <FeaturedPic>
                    <Image
                      src={
                        theme === "dark"
                          ? "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/operations-darkmode.png"
                          : "https://cdn.clikkle.com/SCREEN%20SHOTS/CLIKKLE/HRMS/dedicated%20HR%20app/operations-daymode.png"
                      }
                      width={600}
                      height={600}
                      alt="Hr picture"
                      className="rounded-lg shadow-lg mt-5 relative z-10  md:min-h-[345px]"
                    />
                  </FeaturedPic>
                </div>
                <div className="space-y-8 flex flex-col items-center md:items-end">
                  <div className="space-y-4">
                    {" "}
                    <span className="hidden md:block text-[#286efb] dark:text-[#A9C5FF] text-[16px] font-bold">
                      Feature
                    </span>
                    <h2 className="text-left  text-[1.6rem] md:text-5xl text-gray-900 mt-4 md:mt-0  dark:text-white !leading-[1.2]  font-inter font-[900]  ">
                      Assistance for <br className="hidden sm:block" />
                      <span className="text-[#286efb] dark:text-[#A9C5FF]">
                        HR Management
                      </span>{" "}
                    </h2>
                    <p className="text-left text-gray-600 dark:text-[#d7d7de] max-w-lg font-inter font-normal text-[16px] md:text-[18px]     ">
                      Empower employees with self-service tools and equip HR
                      teams with advanced admin features.
                    </p>
                  </div>

                  <div className="grid grid-cols-2 gap-6 max-w-[517px]">
                    {features4.map((feature, index) => (
                      <div key={index} className="md:space-y-1">
                        <div className="flex items-center gap-3">
                          <div className="w-4 h-4 rounded-lg flex items-center justify-center text-gray-600 dark:text-[#d7d7de]">
                            {feature.icon}
                          </div>
                          <h3 className="text-gray-900 dark:text-[#d7d7de] text-lg font-open-sauce font-black text-[1.16rem]  ">
                            {feature.title}
                          </h3>
                        </div>
                        <p className="text-gray-600 dark:text-[#d7d7de] text-[14px] leading-[20px] pl-[1.75rem] mt-0 font-inter font-normal">
                          {feature.description}
                        </p>
                      </div>
                    ))}
                    <div className="flex items-start gap-6 pt-4">
                      <div className="flex flex-row sm:flex-row sm:items-center gap-4">
                        <Button
                          onClick={() => {
                            window.location.replace(
                              "https://hr.clikkle.com/signup?theme=" +
                              theme +
                              "&referralApp=" +
                              getEncodedReferrer(),
                            );
                          }}
                          className="bg-[#286efb] hover:bg-[#3367d6] text-white px-8 py-3 h-[40px]"
                          style={{
                            boxShadow: `
          0px 0.25px 0.25px 0px rgba(0,0,0,0.24),
          0px 0.75px 0.75px 0px rgba(0,0,0,0.12),
          0px 1px 1.5px -0.5px rgba(0,0,0,0.12),
          0px 2px 4px -1px rgba(0,0,0,0.12),
          0px 4px 8px -4px rgba(0,0,0,0.12),
          0px 8px 12px -4px rgba(0,0,0,0.06)
        `,
                          }}
                        >
                          Get Started
                        </Button>
                      </div>

                      <div className="pl-4 rounded-lg text-gray-600 dark:text-[#d7d7de] font-light hidden md:block max-w-[280px]">
                        <p className="text-sm leading-relaxed font-inter w-60">
                          <span className="text-[#ff4b5c]">&quot;</span>
                          Employee self-service has dramatically reduced HR
                          inquiries.
                          <span className="text-[#ff4b5c]">&quot;</span>
                        </p>

                        <div className="flex items-center gap-3 mt-2">
                          <Image
                            src={user4}
                            alt="David R."
                            className="w-6 h-6 rounded-full"
                            width={24}
                            height={24}
                          />
                          <div>
                            <p className="font-semibold text-sm">David R.</p>
                            <p className="text-xs text-gray-400">
                              HR Operations
                            </p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </section>{" "}
        </section>

        <section className="w-full">
          <AppsSection />
        </section>

        <section className="w-full min-h-[510px]">
          <div className="bg-white dark:bg-[#1a1a1a] py-12 md:py-32 px-4 md:px-0">
            <div className="max-w-3xl mx-auto text-center flex flex-col justify-center items-center">
              <h2 className="text-[34px] md:text-5xl  font-inter  leading-[48px]  [text-stroke:1px_#000] font-bold  text-gray-900 dark:text-white text-center">
                See what our <br className="hidden sm:block" />
                <span className="text-[#286efb] dark:text-[#a9c5ff]  [text-stroke:1px_#000] font-bold">
                  HR leaders
                </span>{" "}
                are saying
              </h2>
              <p className="mt-4 text-gray-600 dark:text-gray-300 text-sm md:text-base font-inter font-normal text-[14px] leading-[20px] tracking-[0em] text-center max-w-[508px]">
                Don&apos;t just take our word for it. See what our valued HR
                professionals have to say about their experience with our
                platform and how it has transformed their people operations.
              </p>
            </div>

            <div className="max-w-2xl mx-auto mt-8 md:px-0">
              <div className="flex justify-center space-x-1">
                {Array(5)
                  .fill(0)
                  .map((_, i) => (
                    <FaStar key={i} className="text-yellow-400" />
                  ))}
              </div>

              <div className="mt-6 flex items-center justify-center">
                <button
                  onClick={prev}
                  className="cursor-pointer p-2 md:p-4 rounded-full border border-gray-300 dark:border-gray-500"
                >
                  <IoIosArrowBack
                    size={18}
                    className="text-gray-900 dark:text-white"
                  />
                </button>

                <p className="mx-4 md:mx-8 text-gray-900 dark:text-white text-sm md:text-lg font-inter font-normal md:font-medium text-[24px] leading-[23px] md:leading-[25px]   text-center md:min-w-[700px]">
                  {text}
                </p>

                <button
                  onClick={next}
                  className="cursor-pointer p-2 md:p-4 rounded-full border border-gray-300 dark:border-gray-500"
                >
                  <IoIosArrowForward
                    size={18}
                    className="text-gray-900 dark:text-white"
                  />
                </button>
              </div>

              <div className="mt-4 text-center text-sm text-gray-600 dark:text-gray-400">
                <span className="text-red-500">*</span>
                {recommendNote}
              </div>

              <div className="mt-6 flex flex-col items-center">
                <Image
                  src={logo}
                  alt="Company Logo"
                  className="h-16 w-16 rounded-full object-cover"
                  width={64}
                  height={64}
                />
                <p className="mt-2 font-medium text-gray-900 dark:text-white">
                  {name}
                </p>
                <p className="text-gray-600 dark:text-gray-400 text-sm">
                  {title}
                </p>
                <p className="text-gray-500 dark:text-gray-500 text-xs mt-1">
                  {date}
                </p>
              </div>
            </div>
          </div>
        </section>

        <section className="w-full" id="moreInfo">
          <section
            className="relative py-16 bg-white dark:bg-[#1a1a1a] overflow-hidden"
            id="pricing"
          >
            <div className="container mx-auto px-4 py-12">
              <div className="flex flex-col md:flex-row items-center justify-center gap-12 md:gap-24">
                <div className="relative w-full md:w-auto flex justify-center">
                  <Image
                    src="/images/free-dog.png"
                    alt="Free forever"
                    width={400}
                    height={400}
                    className="object-contain max-w-[200px] md:max-w-[300px]"
                  />
                </div>

                <div className="w-full md:w-auto text-center md:text-start mx-auto md:mx-0">
                  <h2 className="text-4xl md:text-5xl font-bold text-gray-900 dark:text-white mb-6">
                    Free forever!
                  </h2>
                  <div className="w-full md:w-auto flex justify-center items-center md:block">
                    <ul className="space-y-3 mb-6 text-start">
                      {[
                        "Unlimited Users",
                        "Unlimited Employees",
                        "Unlimited Reports",
                      ].map((item, index) => (
                        <li
                          key={index}
                          className="flex items-center justify-start text-lg text-gray-700 dark:text-gray-300"
                        >
                          <svg
                            className="w-5 h-5 text-blue-500 mr-3 flex-shrink-0"
                            fill="none"
                            stroke="currentColor"
                            viewBox="0 0 24 24"
                          >
                            <path
                              strokeLinecap="round"
                              strokeLinejoin="round"
                              strokeWidth="2"
                              d="M5 13l4 4L19 7"
                            />
                          </svg>
                          {item}
                        </li>
                      ))}
                    </ul>
                  </div>

                  <Link
                    href="https://clikkle.com/offers/hr"
                    className="text-blue-500 hover:text-blue-600 font-medium inline-flex items-center text-lg transition-colors group"
                  >
                    See upgrades
                    <span className="ml-2 transform group-hover:translate-x-1 transition-transform">
                      <ArrowRightIcon className="w-5 h-5" />
                    </span>
                  </Link>
                  <br />
                  <Button
                    onClick={() => {
                      window.location.replace(
                        "https://hr.clikkle.com/signup?theme=" + theme +
                        "&referralApp=" +
                        getEncodedReferrer()
                      );
                    }}
                    className="bg-[#286efb] hover:bg-[#3367d6] text-white px-8 py-3 h-[40px] mt-4"
                  >
                    Try for free
                  </Button>
                </div>
              </div>
            </div>
          </section>
        </section>

        <section className="w-full">
          <section className="w-full py-20 md:py-32 bg-white dark:bg-[#1a1a1a]">
            <div className="container max-w-[694px] mx-auto px-4  text-center">
              <span className="text-gray-900 dark:text-white text-center font-bold text-sm">
                FAQS SECTION
              </span>
              <div className="text-center mb-24 mt-8">
                <h2 className="text-[32px]  [text-stroke:1px_#000] font-boldmd:text-5xl font-medium text-gray-900 dark:text-white mb-6 font-paragraph-inter-m-regular">
                  Frequently Asked Questions
                </h2>
              </div>
              <div className="space-y-4 border border-gray-300 dark:border-[#5e5e69] rounded-xl overflow-hidden transition-colors bg-gray-100 dark:bg-[#141414] p-2">
                {faqs.map((faq, index) => {
                  const isOpen = openFAQ === index;
                  return (
                    <React.Fragment key={index}>
                      <div
                        className={`rounded-xl overflow-hidden transition-colors !mt-[0px] ${isOpen
                            ? "bg-white dark:bg-[#1a1a1a]"
                            : "bg-gray-100 dark:bg-[#141414]"
                          }`}
                      >
                        <button
                          className="w-full px-4 py-5 text-left flex items-center justify-between hover:bg-white dark:hover:bg-[#1a1a1a] transition-colors"
                          onClick={() => setOpenFAQ(isOpen ? null : index)}
                        >
                          <h3 className="text-lg font-[400] text-gray-900 dark:text-white pr-4">
                            {faq.question}
                          </h3>
                          <ArrowDown
                            className={`w-6 h-6 text-black bg-gray-300 dark:bg-[#d7d7de] rounded-full p-1 font-bold transition-transform ${isOpen ? "rotate-180" : ""
                              }`}
                          />
                        </button>

                        {isOpen && (
                          <div className="pr-8 pl-4 pb-6">
                            <p className="text-[#51515E] dark:text-[#EEEEF0] text-start font-[300] text-md">
                              {faq.answer}
                            </p>
                          </div>
                        )}
                      </div>
                      {index < 4 && (
                        <hr className="h-px bg-gray-300 dark:bg-[#5e5e69] border-0 !m-[5px]" />
                      )}
                    </React.Fragment>
                  );
                })}
              </div>
            </div>
          </section>
        </section>
        <section className="w-full flex justify-center items-center">
          <div className="bg-[#edeef1] dark:bg-[#141414] p-10 md:pt-10 pt-16 rounded-[20px] border-2 border-dashed border-gray-300 dark:border-[#575662] my-24 mx-[1.2rem] md:mx-[50px] md:max-w-[1062px] relative overflow-hidden md:overflow-visible">
            <div className="flex flex-col-reverse md:flex-row items-center md:items-start h-full">
              <div className="w-full text-center md:text-left flex flex-col justify-between gap-4 h-full md:w-[1062px] pt-36 md:pt-0">
                <div>
                  <h2 className="!text-[30px] md:!text-[55px] leading-none font-bold text-gray-900 dark:text-white">
                    Transform Your{" "}
                    <span className="text-[#286efb] dark:text-[#a9c5ff]">
                      People
                    </span>
                  </h2>
                  <h3 className="!text-[30px] md:!text-[55px] font-bold text-gray-900 dark:text-white leading-tight">
                    Management Today
                  </h3>
                </div>

                <p className="mt-4 text-gray-600 dark:text-gray-300 text-base md:text-lg">
                  Automate HR workflows, enhance employee experience, and gain
                  <br className="hidden sm:block" />
                  actionable insights with our all-in-one HR platform
                </p>

                <div className="mt-6 w-full max-w-xl flex flex-col items-center md:items-start gap-4">
                  <div className="flex flex-col sm:flex-row items-center sm:items-stretch gap-3 w-full">
                    <input
                      type="email"
                      placeholder="Enter Your Email"
                      className="flex-1 px-4 py-3 rounded-lg bg-white text-gray-900 placeholder-gray-500 dark:placeholder-gray-400 focus:outline-none w-full border border-gray-300 dark:border-[#575662] shadow-sm dark:shadow-none"
                    />
                    <button
                      onClick={() => {
                        window.location.replace(
                          "https://hr.clikkle.com/signup?theme=" +
                          theme +
                          "&referralApp=" +
                          getEncodedReferrer(),
                        );
                      }}
                      className="cursor-pointer px-6 py-3 bg-black dark:bg-[#286efb] text-white font-medium rounded-lg transition w-full sm:w-auto"
                    >
                      Get Started for Free
                    </button>
                  </div>

                  <div className="flex items-start gap-2 text-sm text-gray-600 dark:text-gray-300">
                    <label className="relative flex items-center cursor-pointer">
                      <input
                        type="checkbox"
                        id="terms"
                        defaultChecked
                        className="peer appearance-none h-4 w-4 border-2 border-blue-500 rounded-full bg-white dark:bg-gray-800 checked:bg-[#286efb] checked:border-blue-500 checked:ring-2 checked:ring-blue-300 transition duration-200"
                      />
                      <span className="absolute left-0 top-0 h-4 w-4 flex items-center justify-center pointer-events-none peer-checked:before:content-['✓'] peer-checked:before:text-white peer-checked:before:text-sm peer-checked:before:font-bold"></span>
                    </label>

                    <span className="ml-1 leading-5">
                      I agree with the{" "}
                      <Link
                        href="/terms-of-service"
                        className="underline text-gray-900 dark:text-gray-100 hover:text-[#51515E] dark:hover:text-white"
                        target="_blank"
                        rel="noopener noreferrer"
                      >
                        Terms and Conditions
                      </Link>
                    </span>
                  </div>
                </div>
              </div>

              <div className="w-full md:w-1/2 md:h-full md:self-end flex md:justify-end md:items-end justify-center items-center relative">
                <Image
                  src={theme === "dark" ? ctaBlack : ctaimage}
                  alt="HR Illustration"
                  className="w-[11.5rem] sm:w-[13rem] md:w-[340px] absolute left-1/2 md:left-auto top-[-48px] md:top-auto md:bottom-[-42px] md:right-[-35px] -translate-x-1/2 md:translate-x-0 z-10 pointer-events-none"
                  width={340}
                  height={200}
                />
              </div>
            </div>
          </div>
        </section>
      </div>
      <Footer
        footerText="Transform your HR operations with our modern platform. Comprehensive solutions for every organization."
        darkLogo={
          "https://cdn.clikkle.com/images/worksuite/2025/Clikkle%20Worksuite%20Blue%20(%20White%20Text).png"
        }
        lightLogo={
          "https://cdn.clikkle.com/images/worksuite/2025/Clikkle%20Worksuite%20Blue%20(%20Black%20Text).png"
        }
        footerName={"Hr"}
      />

      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
    </div>
  );
};

export default HrHome;
