/* eslint-disable @next/next/no-img-element */
 
"use client";
import React, { useEffect, useRef, useState } from "react";
import { ArrowRightIcon, Ellipsis, Logs } from "lucide-react";
import { FaArrowRight } from "react-icons/fa";
import Link from "next/link";
import Image from "next/image";
import { footerColumns } from "../constants/footerText";
import { useTheme } from "../atoms/theme";
import SidebarDrawer from "../components/sidebarDrawer";
import ThemeSwitch from "../components/themeSwitch";
import { Button } from "../components/button";
import { apps } from "../constants/products";
import illustration from "../../public/images/new7.png";
import ctaimage from "../../public/images/ctaWhite.png";
import ctaBlack from "../../public/images/ctaBlack.png";
import {
  Globe,
  MessageCircle,
  FileSignature,
  Users,
  CheckSquare,
  FolderOpen,
  Mail,
  Smartphone,
  Heart,
  Zap,
  Newspaper,
  BarChart3,
  Briefcase,
  Server,
  Star,
  DollarSign,
  Calendar,
  Search,
} from "lucide-react";
import AnnouncementBar from "../components/AnnouncementBar";
import { getCookie } from "../utils/cookies";
import ClikkleLogo from "@/components/ClikkleLogo";
import Footer from "@/components/Footer";
import SecuritySection from "../components/SecuritySection";
import { getEncodedReferrer } from "@/utils/utils";

interface AppCardProps {
  icon: React.ElementType;
  name: string;
  description: string;
  comingSoon?: boolean;
  image?: string;
  route: string;
  category?: string;
}

const AppCard: React.FC<AppCardProps> = ({
  image,
  name,
  description,
  comingSoon = false,
  route,
  category,
}) => {
  const { theme } = useTheme();

  return (
    <Link href={comingSoon ? "#" : route} className="h-full block">
      <div className={`relative group h-full flex flex-col bg-white dark:bg-[#1a1a1a] border border-gray-200 dark:border-[#575662] rounded-2xl hover:shadow-xl hover:shadow-blue-500/10 dark:hover:shadow-blue-900/20 transition-all duration-300 hover:-translate-y-1 overflow-hidden ${comingSoon ? "" : ""
        }`}>
        <div className="p-6 flex flex-col flex-1">
          <div className="flex items-center justify-between mb-4">
            <div className="w-12 h-12 rounded-xl flex items-center justify-center bg-gray-50 dark:bg-[#252432] group-hover:scale-110 transition-transform duration-300">
              <img src={image} className="w-7 h-auto" alt={name} />
            </div>
            {!comingSoon && (
              <div className="opacity-0 group-hover:opacity-100 transition-opacity duration-300 transform translate-x-2 group-hover:translate-x-0">
                <ArrowRightIcon className="w-5 h-5 text-[#286efb]" />
              </div>
            )}
          </div>

          <div className="flex-1">
            <h3 className="text-lg font-bold text-gray-900 dark:text-white mb-2 group-hover:text-[#286efb] transition-colors">
              {name}
            </h3>
            <p className="text-sm text-gray-600 dark:text-gray-400 leading-relaxed line-clamp-3">
              {description}
            </p>
          </div>
        </div>

        <div className="w-full h-px bg-gray-100 dark:bg-[#575662]" />
        <div className="flex flex-row justify-between items-center">
          <div className="px-6">
            <div className="flex items-center gap-2 text-xs font-medium text-gray-500 dark:text-gray-400">
              <span>App</span>
              <span className="w-1 h-1 rounded-full bg-gray-300 dark:bg-gray-600" />
              <span>Free</span>
            </div>
          </div>
          <div className="px-6 py-4">
            <Button
              asChild
              variant="ghost"
              onClick={(e) => {
                e.preventDefault();
                e.stopPropagation();
                if (comingSoon) return;
                const subdomain = route.startsWith("/") ? route.substring(1) : route;
                window.location.replace(
                  `https://${subdomain}.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`
                );
              }}
              className={`cursor-pointer justify-between hover:bg-[#286efb] hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-xl text-xs px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
            >
              <div>
                Try {name} for free
                <ArrowRightIcon className="h-2 w-2 dark:text-white" />
              </div>
            </Button>
          </div>


        </div>

        <div className="px-6 py-3 bg-gray-50 dark:bg-[#141414] border-t border-gray-100 dark:border-[#2f2e3d]">
          <div className="flex items-center gap-1.5 text-xs text-gray-500 dark:text-gray-400">
            <span>Powered by n5 Nucleus</span>
            <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round" className="opacity-50"><circle cx="12" cy="12" r="10" /><path d="M12 16v-4" /><path d="M12 8h.01" /></svg>
          </div>
        </div>

        {comingSoon && (
          <div className="absolute inset-0 flex items-center justify-center bg-white/60 dark:bg-[#1a1a1a]/60 backdrop-blur-[2px] z-10">
            <span className="bg-[#286efb] text-white px-4 py-1.5 rounded-full text-xs font-bold shadow-lg">
              Coming Soon
            </span>
          </div>
        )}
      </div>
    </Link>
  );
};

interface SectionProps {
  title: string;
  apps: Array<{
    icon: React.ElementType;
    name: string;
    description: string;
    iconColor: string;
    comingSoon?: boolean;
    route: string;
  }>;
}

const Section: React.FC<SectionProps> = ({ title, apps }) => {
  return (
    <div className="mb-16">
      <h2 className="text-3xl font-bold mb-8 relative">{title}</h2>
      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        {apps.map((app, index) => (
          <AppCard key={index} {...app} route={app.route} category={title} />
        ))}
      </div>
    </div>
  );
};

function AllProducts() {
  const { theme } = useTheme();
  const [searchQuery, setSearchQuery] = useState("");

  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);

  const sections = [
    {
      title: "Collaboration",
      apps: [
        {
          icon: Globe,
          name: "Worksuite",
          description: "A unified ecosystem of business tools to streamline operations and team productivity.",
          iconColor: "bg-teal-500",
          image: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
          route: "/worksuite",
        },
        {
          icon: MessageCircle,
          name: "Chat",
          description: "Secure real-time messaging and file sharing for seamless team and customer communication.",
          iconColor: "bg-purple-500",
          image: "https://cdn.clikkle.com/images/chat/logo/2025/clikkle%20chat.png",
          route: "/chat",
        },
        {
          icon: FolderOpen,
          name: "Files",
          description: "Secure cloud storage with advanced permission controls and real-time collaboration.",
          iconColor: "bg-blue-500",
          image: "https://cdn.clikkle.com/images/files/logo/2025/clikkle%20files.png",
          route: "/files",
        },
        {
          icon: FileSignature,
          name: "eSign",
          description: "Legally binding digital signatures to sign and manage documents securely from any device.",
          iconColor: "bg-pink-500",
          image: "https://cdn.clikkle.com/images/e-sign/logo/2025/clikkle%20esign.png",
          route: "/esign",
        },
        {
          icon: Calendar,
          name: "Calendar",
          description: "Smart scheduling and event management with automated reminders and team syncing.",
          iconColor: "bg-pink-500",
          image: "https://cdn.clikkle.com/images/calendar/logo/2025/Clikkle%20Calendar.png",
          route: "/calendar",
        },
        {
          icon: Briefcase,
          name: "Crew",
          image: "https://cdn.clikkle.com/images/crew/logo/2025/Clikkle%20Crew.png",
          description: "HD video conferencing with screen sharing and interactive team meeting tools.",
          iconColor: "bg-orange-500",
          route: "/crew",
        },
      ],
    },
    {
      title: "Human Resources",
      apps: [
        {
          icon: Users,
          name: "HR",
          description: "Modern HR management for onboarding, payroll, attendance, and performance tracking.",
          iconColor: "bg-teal-500",
          image: "https://cdn.clikkle.com/images/hr/logo/2025/clikkle%20hr.png",
          route: "/hr",
        },
      ],
    },
    {
      title: "Projects",
      apps: [
        {
          icon: CheckSquare,
          name: "Projects",
          description: "Project management featuring Kanban boards and Gantt charts for task execution.",
          iconColor: "bg-orange-500",
          image: "https://cdn.clikkle.com/images/projects/logo/2025/clikkle%20projects.png",
          route: "/projects",
        },
      ],
    },
    {
      title: "Marketing & Sales",
      apps: [
        {
          icon: Zap,
          name: "Campaigns",
          description: "Data-driven platform to manage and optimize multi-channel marketing campaigns.",
          iconColor: "bg-blue-500",
          image: "https://cdn.clikkle.com/images/campaigns/logo/2025/clikkle%20campaigns.png",
          route: "/campaigns",
        },
        {
          icon: Users,
          name: "CRM",
          description: "Manage leads, contacts, and customer relationships through the sales pipeline.",
          iconColor: "bg-purple-500",
          image: "https://cdn.clikkle.com/images/crm/2025/clikkle%20crm.png",
          route: "/crm",
        },
        {
          icon: Mail,
          name: "Cmail",
          image: "https://cdn.clikkle.com/images/cmail/logo/2023/cmail.png",
          description: "Professional email marketing for automated newsletters and performance analytics.",
          iconColor: "bg-teal-500",
          comingSoon: true,
          route: "/cmail",
        },
        {
          icon: Smartphone,
          name: "SMS",
          image: "https://cdn.clikkle.com/images/sms/logo/2023/sms.png",
          description: "Bulk SMS service for instant customer notifications and personalized alerts.",
          iconColor: "bg-orange-500",
          comingSoon: true,
          route: "/sms",
        },
        {
          icon: Heart,
          name: "Social",
          image: "https://cdn.clikkle.com/images/social/logo/2023/social.png",
          description: "Centralized dashboard to schedule posts and analyze social media engagement.",
          iconColor: "bg-pink-500",
          route: "/social",
          comingSoon: true,
        },
        {
          icon: BarChart3,
          name: "Ads",
          image: "https://cdn.clikkle.com/images/ads/logo/2023/ads.png",
          description: "Comprehensive platform to create, track, and optimize cross-network ad campaigns.",
          iconColor: "bg-purple-500",
          route: "/ads",
          comingSoon: true,
        },
      ],
    },
    {
      title: "Finance",
      apps: [
        {
          icon: DollarSign,
          name: "Tax",
          image: "https://cdn.clikkle.com/images/tax/logo/2023/tax.png",
          comingSoon: true,
          description: "Simplified tax management for filing, tracking, and business compliance.",
          iconColor: "bg-gray-700",
          route: "/tax",
        },
      ],
    },
    {
      title: "Media & Outreach",
      apps: [
        {
          icon: Newspaper,
          name: "Creator AI",
          image: "https://cdn.clikkle.com/images/creator/logo/2025/Clikkle%20Creator.png",
          description: "AI studio for generating engaging text, images, and media content.",
          iconColor: "bg-blue-500",
          route: "/creator",
        },
        {
          icon: Newspaper,
          name: "News",
          image: "https://cdn.clikkle.com/images/news/logo/2023/news.png",
          description: "Digital publishing platform to distribute and monetize news and newsletters.",
          iconColor: "bg-blue-500",
          route: "/news",
          comingSoon: true,
        },
        {
          icon: Star,
          name: "Pitch",
          description: "Professional presentation builder with customizable templates and sharing tools.",
          image: "https://cdn.clikkle.com/images/pitch/logo/2023/pitch.png",
          iconColor: "bg-teal-500",
          route: "/pitch",
          comingSoon: true,
        },
        {
          icon: Globe,
          name: "Launch",
          description: "Management platform to coordinate product releases and marketing announcements.",
          image: "https://cdn.clikkle.com/images/launch/logo/2023/launch.png",
          iconColor: "bg-orange-500",
          route: "/launch",
          comingSoon: true,
        },
        {
          icon: Star,
          name: "KeptUp",
          description: "Trend monitoring tool to stay updated on industry news and viral content.",
          image: "https://cdn.clikkle.com/images/kept-up/logo/2023/kept-up.png",
          iconColor: "bg-pink-500",
          route: "/kept-up",
          comingSoon: true,
        },
      ],
    },
    {
      title: "Hosting & Extras",
      apps: [
        {
          icon: Server,
          name: "Host",
          description: "Scalable web hosting infrastructure with high performance and 24/7 support.",
          iconColor: "bg-teal-500",
          image: "https://cdn.clikkle.com/images/host/logo/2025/clikkle%20host.png",
          route: "/host",
        },
        {
          icon: Star,
          name: "Swiprr",
          description: "Swipe-based interface for exploring trending media and personalized content.",
          iconColor: "bg-blue-500",
          image: "https://cdn.clikkle.com/images/swiprr/logo/2023/swiprr.png",
          route: "/swiprr",
          comingSoon: true,
        },
      ],
    },
  ];

  const [productsOpen, setProductsOpen] = useState(false);
  const [dotsOpen, setDotsOpen] = useState(false);
  const productsRef = useRef<HTMLDivElement>(null);
  const dotsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (
        productsRef.current &&
        !productsRef.current.contains(event.target as Node)
      ) {
        setProductsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (dotsRef.current && !dotsRef.current.contains(event.target as Node)) {
        setDotsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);
  const [scrolled, setScrolled] = useState(false);
  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 0);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const [announcementOpen, setAnnouncementOpen] = useState(false);

  useEffect(() => {
    const checkHeight = () => {
      const el = document.querySelector("[data-announcement]") as HTMLElement;
      if (el && el.offsetHeight > 0) {
        setAnnouncementOpen(true);
      } else {
        setAnnouncementOpen(false);
      }
    };
    checkHeight();
    const observer = new MutationObserver(checkHeight);
    observer.observe(document.body, { childList: true, subtree: true });
    return () => observer.disconnect();
  }, []);

  useEffect(() => {
    const checkDismissedAnnouncements = () => {
      const dismissed = getCookie("dismissedAnnouncements");
      if (dismissed) {
        try {
          const dismissedIds = JSON.parse(dismissed);
          if (dismissedIds.length > 0) {
            setAnnouncementOpen(false);
          }
        } catch (error) {
          console.error("Error parsing dismissed announcements:", error);
        }
      }
    };

    checkDismissedAnnouncements();
  }, []);

  const allApps = sections.flatMap((section) =>
    section.apps.map((app) => ({ ...app, category: section.title }))
  );
  const searchResults = searchQuery
    ? allApps.filter(
      (app) =>
        app.name.toLowerCase().includes(searchQuery.toLowerCase()) ||
        app.description.toLowerCase().includes(searchQuery.toLowerCase())
    )
    : [];

  return (
    <div className="min-h-screen bg-white dark:bg-[#1a1a1a] transition-colors duration-300">
      <section className="w-full">
        <section className="relative w-full  overflow-hidden">
          <div
            className={`fixed top-0 inset-x-0 z-50 ${scrolled
              ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1a1a]/90"
              : productsOpen || dotsOpen
                ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1a1a]/90"
                : ""
              }`}
          >
            <div
              ref={(el) => {
                if (el) {
                  const height = el.getBoundingClientRect().height;

                  if (height !== 0) {
                    setAnnouncementOpen(true);
                  }
                }
              }}
            >
              <AnnouncementBar onClose={() => setAnnouncementOpen(false)} />
            </div>
            <div className="container max-w-[1233px] mx-auto max-[1300px]:px-14 max-[1100px]:px-4">
              <nav
                className={`relative flex items-center justify-between py-4`}
              >
                <ClikkleLogo />

                <div className="flex md:hidden items-center">
                  <div
                    className="flex items-center gap-0 rounded-xl border border-gray-300 dark:border-[#ffffff3a] p-[8px] shadow-sm"
                    onClick={toggleLeftDrawer}
                  >
                    <p className="text-sm font-medium text-gray-900 dark:text-white">
                      <Logs className="w-5 h-5 text-gray-900 dark:text-white mr-3" />
                    </p>

                    <p className="flex items-center  rounded-xl text-sm font-bold ">
                      Menu
                    </p>
                  </div>
                </div>

                <div className="hidden md:flex items-center gap-12  font-inter font-medium text-[18px]">
                  <Link
                    href="#features"
                    className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                  >
                    Features
                  </Link>
                  <Link
                    href="https://clikkle.com/#pricing"
                    className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                  >
                    Pricing
                  </Link>
                  <Link
                    href="/blogs"
                    className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                  >
                    Blog
                  </Link>
                  <div className="flex flex-row justify-center items-center">
                    <div className="relative" ref={productsRef}>
                      <button
                        onClick={() => setProductsOpen((o) => !o)}
                        className="cursor-pointer flex items-center gap-1 text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                      >
                        Products
                      </button>
                      {productsOpen && (
                        <div
                          className={`fixed ${announcementOpen ? "top-[115px]" : "top-[75px]"
                            } 
              left-1/2 transform -translate-x-1/2 w-full bg-white/90 dark:bg-[#1a1a1a]/90 backdrop-blur-md 
              shadow-lg p-6 border-b-2 border-gray-300 dark:border-[#575662] z-50 flex justify-center items-center pb-0`}
                        >
                          <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                            <div className="flex flex-col gap-3">
                              {apps
                                .slice(0, Math.ceil(apps.length / 2))
                                .map((product) => (
                                  <Link
                                    key={product.id}
                                    href={product.route}
                                    className="flex items-center gap-4 p-[0.35rem] rounded-lg hover:bg-gray-100 dark:hover:bg-white/10 transition"
                                  >
                                    <div>
                                      <Image
                                        src={product.image}
                                        alt={product.title}
                                        className="w-[26px]"
                                        width={26}
                                        height={26}
                                      />
                                    </div>
                                    <div>
                                      <p className="font-bold text-gray-900 dark:text-white text-sm">
                                        {product.title}
                                      </p>
                                      <p className="text-xs text-gray-600 dark:text-gray-300">
                                        {product.description}
                                      </p>
                                    </div>
                                  </Link>
                                ))}
                            </div>

                            <div className="flex flex-col gap-3">
                              {apps
                                .slice(
                                  Math.ceil(apps.length / 2),
                                  Math.ceil(apps.length / 2) + 2,
                                )
                                .map((product) => (
                                  <Link
                                    key={product.id}
                                    href={product.route}
                                    className="flex items-center gap-4 p-[0.35rem] rounded-lg hover:bg-gray-100 dark:hover:bg-white/10 transition"
                                  >
                                    <div>
                                      <Image
                                        src={product.image}
                                        alt={product.title}
                                        className="w-[26px]"
                                        width={26}
                                        height={26}
                                      />
                                    </div>
                                    <div>
                                      <p className="font-bold text-gray-900 dark:text-white text-sm">
                                        {product.title}
                                      </p>
                                      <p className="text-xs text-gray-600 dark:text-gray-300">
                                        {product.description}
                                      </p>
                                    </div>
                                  </Link>
                                ))}
                              <Link href="/products">
                                <Button
                                  style={{ marginTop: "5px" }}
                                  variant="ghost"
                                  className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                >
                                  View all products
                                  <ArrowRightIcon className="h-2 w-2 dark:text-white" />
                                </Button>
                              </Link>
                            </div>

                            <div className="hidden lg:flex flex-row items-center justify-center text-center gap-3">
                              <Image
                                src={illustration}
                                alt="Illustration"
                                className="w-auto h-[175px]"
                                width={200}
                                height={175}
                              />
                              <div className="flex flex-col justify-center items-center h-full">
                                <p className="text-sm text-gray-700 dark:text-gray-300 max-w-[200px] pb-5">
                                  Get started today the modern solution to power
                                  your business.
                                </p>
                                <Button
                                  variant="ghost"
                                  onClick={() => {
                                    window.location.replace(
                                      `https://worksuite.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`,
                                    );
                                  }}
                                  className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                >
                                  Get Started Today
                                  <ArrowRightIcon
                                    className={`h-2 w-2 dark:text-white`}
                                  />
                                </Button>
                              </div>
                            </div>
                          </div>
                        </div>
                      )}
                    </div>

                    <div className="relative" ref={dotsRef}>
                      <Ellipsis
                        onClick={() => setDotsOpen((o) => !o)}
                        className="w-8 h-6 rounded-full p-[1px] cursor-pointer"
                      />
                      {dotsOpen && (
                        <div
                          className={`fixed ${announcementOpen ? "top-[115px]" : "top-[75px]"
                            }  left-1/2 transform -translate-x-1/2 w-full 
    bg-white/90 dark:bg-[#1a1a1a]/90 backdrop-blur-md 
    shadow-lg border-b-2 border-gray-300 dark:border-[#575662] 
    z-50 flex justify-center`}
                        >
                          <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 py-6">
                            <div className="flex flex-col md:flex-row justify-between items-start gap-12">
                              <div className="space-y-12">
                                <div className="max-w-[285px] space-y-2 mb-0">
                                  <h3 className="font-instrument-sans font-medium text-[18px] leading-[20px] text-gray-900 dark:text-[#eeeef0]">
                                    Get Started For Free
                                  </h3>
                                  <p className="font-body-medium text-[#51515E] dark:text-[#eeeef0]">
                                    Streamline your Business with our Apps.
                                    Effortlessly for every team.
                                  </p>
                                </div>
                                <Button
                                  style={{ marginTop: "20px" }}
                                  variant="ghost"
                                  onClick={() => {
                                    window.location.replace(
                                      `https://worksuite.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`,
                                    );
                                  }}
                                  className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                >
                                  See How It Works
                                  <ArrowRightIcon
                                    className={`h-2 w-2 dark:text-white`}
                                  />
                                </Button>
                              </div>

                              <div className="flex flex-wrap gap-x-14 gap-y-8 text-xs sm:text-sm">
                                {footerColumns.map((column, index) => (
                                  <div
                                    key={index}
                                    className="flex flex-col gap-5"
                                  >
                                    <h4 className="font-label-medium text-gray-900 dark:text-white">
                                      {column.title}
                                    </h4>
                                    <ul className="flex flex-col gap-4">
                                      {column.links.map((link, linkIndex) => (
                                        <li key={linkIndex}>
                                          <div className="flex items-start gap-3">
                                            <Link
                                              href={link.url}
                                              target={
                                                link.url.startsWith("http")
                                                  ? "_blank"
                                                  : "_self"
                                              }
                                              rel={
                                                link.url.startsWith("http")
                                                  ? "noopener noreferrer"
                                                  : undefined
                                              }
                                              className="font-body-medium text-[#51515E] dark:text-[#d7d7de] hover:text-gray-900 dark:hover:text-white transition-colors whitespace-nowrap flex items-center gap-2"
                                            >
                                              {link.text}
                                              {column.title === "Social" && (
                                                <FaArrowRight className="w-2 h-2" />
                                              )}
                                            </Link>

                                            {link.isNew && (
                                              <div className="hidden md:flex items-center gap-2">
                                                <div className="w-4 h-4 flex items-center justify-center">
                                                  <div className="w-[13px] h-[13px] bg-[#c3e6ff] rounded-[6.67px] flex items-center justify-center">
                                                    <div className="w-1 h-1 bg-[#286efb] rounded-sm" />
                                                  </div>
                                                </div>
                                                <span className="font-body-medium text-gray-900 dark:text-white whitespace-nowrap">
                                                  New
                                                </span>
                                              </div>
                                            )}
                                          </div>
                                        </li>
                                      ))}
                                    </ul>
                                  </div>
                                ))}
                              </div>
                            </div>
                          </div>
                        </div>
                      )}
                    </div>
                  </div>
                </div>

                <div className="hidden md:flex items-center gap-4">
                  <div className="hidden md:flex items-center gap-4">
                    <div className="w-6">
                      <ThemeSwitch />
                    </div>
                    <div className="flex items-center gap-2 rounded-xl border border-gray-300 dark:border-[#ffffff3a] p-1 shadow-sm">
                      <button
                        className="cursor-pointer px-3 py-1 text-sm font-medium text-gray-900 dark:text-white"
                        onClick={() => {
                          window.location.replace(
                            `https://worksuite.clikkle.com/login?theme=${theme}&referralApp=${getEncodedReferrer()}`,
                          );
                        }}
                      >
                        Login
                      </button>

                      <button
                        className="cursor-pointer flex items-center gap-1 rounded-xl bg-[#286efb] hover:bg-[#3367d6] px-4 py-1.5 text-sm font-medium text-white transition"
                        onClick={() => {
                          window.location.replace(
                            `https://worksuite.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`,
                          );
                        }}
                      >
                        Try it&apos;s free
                        <span>
                          <ArrowRightIcon className="w-4" />
                        </span>
                      </button>
                    </div>
                  </div>
                </div>
              </nav>
            </div>
          </div>
        </section>
      </section>
      <div
        className={`max-w-7xl mx-auto px-6 ${announcementOpen ? "pt-20" : "pt-16"
          }`}
      >
        <div className="text-center mt-20 mb-16 space-y-6 px-4">
          <h1 className="text-4xl md:text-5xl font-bold text-gray-900 dark:text-white tracking-tight">
            <span className="text-[#286efb] dark:text-[#a9c5ff]">N5 Nucleus</span> Products
          </h1>
          <p className="max-w-2xl mx-auto text-lg text-gray-600 dark:text-gray-300 leading-relaxed">
            Experience a total sovereign enterprise ecosystem <br className="hidden sm:block"/>
            powered by G7 Core and automated by Q7.
          </p>
          <div className="pt-4">
            <Button
              onClick={() => {
                window.location.replace(
                  `https://worksuite.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`,
                );
              }}
              variant="ghost"
              className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
            >
              Get Started for Free
              <ArrowRightIcon className="h-2 w-2 dark:text-white" />
            </Button>
          </div>
        </div>

        <div className="mb-10 flex flex-col md:flex-row justify-between items-end gap-6 border-b border-gray-200 dark:border-[#575662] pb-6">
          <div>
            <h2 className="text-3xl font-bold text-gray-900 dark:text-white mb-2">
              {searchQuery ? "Search Results" : "All Apps"}
            </h2>
            <p className="text-gray-600 dark:text-gray-400">
              {searchQuery
                ? `Found ${searchResults.length} apps matching "${searchQuery}"`
                : "Explore our N5-powered collection of sovereign business tools."}
            </p>
          </div>
          <div className="relative w-full md:w-80">
            <div className="absolute left-4 top-1/2 -translate-y-1/2 text-gray-400 pointer-events-none">
              <Search className="w-4 h-4" />
            </div>
            <input
              type="text"
              placeholder="Search products..."
              value={searchQuery}
              onChange={(e) => setSearchQuery(e.target.value)}
              className="w-full pl-11 pr-4 py-2.5 border border-gray-200 dark:border-[#575662] rounded-xl bg-white dark:bg-[#1a1a1a] text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-[#575662] focus:border-transparent transition-all shadow-sm text-sm placeholder-gray-400"
            />
          </div>
        </div>

        {searchQuery ? (
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-24">
            {searchResults.map((app, index) => (
              <AppCard key={index} {...app} route={app.route} />
            ))}
            {searchResults.length === 0 && (
              <div className="col-span-full text-center py-20">
                <p className="text-gray-500 dark:text-gray-400 text-lg">No apps found matching your search.</p>
              </div>
            )}
          </div>
        ) : (
          <div className="space-y-16 mb-24">
            {sections.map((section, index) => (
              <Section key={index} title={section.title} apps={section.apps} />
            ))}
          </div>
        )}

        <SecuritySection />

        <section className="w-full flex justify-center items-center">
          <div className="bg-[#edeef1] dark:bg-[#141414] p-10 md:pt-10 pt-16 rounded-[20px] border-2 border-dashed border-gray-300 dark:border-[#575662] my-24 mx-[1.2rem] md:mx-[50px] md:max-w-[1062px] relative overflow-hidden md:overflow-visible">
            <div className="flex flex-col-reverse md:flex-row items-center md:items-start h-full">
              <div className="w-full text-center md:text-left flex flex-col justify-between gap-4 h-full md:w-[1062px] pt-36 md:pt-0">
                <div>
                  <h2 className="!text-[30px] md:!text-[55px] leading-none font-bold text-gray-900 dark:text-white">
                    Simplify{" "}
                    <span className="text-[#286efb] dark:text-[#a9c5ff]">
                      Processes
                    </span>
                  </h2>
                  <h3 className="!text-[30px] md:!text-[55px] font-bold text-gray-900 dark:text-white leading-tight">
                    Boost Productivity
                  </h3>
                </div>

                <p className="mt-4 text-gray-600 dark:text-gray-300 text-base md:text-lg">
                  Manage Organizations efficiently with powerful tools and{" "}
                  <br className="hidden sm:block" />
                  collaborate seamlessly, anywhere, anytime.
                </p>

                <div className="mt-6 w-full max-w-xl flex flex-col items-center md:items-start gap-4">
                  <div className="flex flex-col sm:flex-row items-center sm:items-stretch gap-3 w-full">
                    <input
                      type="email"
                      placeholder="Enter Your Email"
                      className="flex-1 px-4 py-3 rounded-lg bg-white text-gray-900 placeholder-gray-500 dark:placeholder-gray-400 focus:outline-none w-full border border-gray-300 dark:border-[#575662] shadow-sm dark:shadow-none"
                    />
                    <Button
                      variant="ghost"
                      onClick={() => {
                        window.location.replace(
                          `https://worksuite.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`,
                        );
                      }}
                      className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                    >
                      Get Started for Free
                      <ArrowRightIcon className="h-2 w-2 dark:text-white" />
                    </Button>
                  </div>

                  <div className="flex items-start gap-2 text-sm text-gray-600 dark:text-gray-300">
                    <label className="relative flex items-center h-full cursor-pointer">
                      <input
                        type="checkbox"
                        id="terms"
                        defaultChecked
                        className="peer appearance-none h-4 w-4 border-2 border-blue-500 rounded-full bg-white dark:bg-[#575662] checked:bg-[#286efb] checked:border-blue-500 checked:ring-2 checked:ring-blue-300 transition duration-200"
                      />
                      <span className="absolute left-0 top-0 h-4 w-4 flex items-center justify-center pointer-events-none peer-checked:before:content-['✓'] peer-checked:before:text-white peer-checked:before:text-sm peer-checked:before:font-bold"></span>
                    </label>

                    <span className="ml-1 leading-5">
                      I agree with the{" "}
                      <Link
                        href="/terms-of-service"
                        className="underline text-gray-900 dark:text-gray-100 hover:text-[#51515E] dark:hover:text-white"
                        target="_blank"
                        rel="noopener noreferrer"
                      >
                        Terms and Conditions
                      </Link>
                    </span>
                  </div>
                </div>
              </div>

              <div className="w-full md:w-1/2 md:h-full md:self-end flex md:justify-end md:items-end justify-center items-center relative">
                <Image
                  src={theme === "dark" ? ctaBlack : ctaimage}
                  alt="eSignature Illustration"
                  className="w-[11.5rem] sm:w-[13rem] md:w-[340px] absolute left-1/2 md:left-auto top-[-48px] md:top-auto md:bottom-[-42px] md:right-[-35px] -translate-x-1/2 md:translate-x-0 z-10 pointer-events-none"
                  width={340}
                  height={400}
                />
              </div>
            </div>
          </div>
        </section>
      </div>

      <Footer />
      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
    </div>
  );
}

export default AllProducts;