"use client";
import { Button } from "../components/button";
import SidebarDrawer from "../components/sidebarDrawer";
import { FaArrowRight } from "react-icons/fa";
import { ArrowRightIcon, Ellipsis, Logs } from "lucide-react";
import ThemeSwitch from "../components/themeSwitch";
import { useTheme } from "../atoms/theme";
import { useEffect, useRef, useState } from "react";
import collage from "../../public/images/collage.png";
import Stephan from "../../public/images/ceo-img-3.jpg";
import endorsementImg from "../../public/images/endorsement.png";
import illustration from "../../public/images/banner.png";
import { apps } from "../constants/products";
import Link from "next/link";
import Image from "next/image";
import { footerColumns } from "../constants/footerText";
import SignWhite from "../../public/images/StephanWhite.png";
import SignDark from "../../public/images/StephanDark.png";
import workdark from "../../public/images/workdark.png";
import worklight from "../../public/images/worklight.png";
import AnnouncementBar from "../components/AnnouncementBar";
import { getCookie } from "../utils/cookies";
import ClikkleLogo from "../components/ClikkleLogo";
import Footer from "@/components/Footer";
import { getEncodedReferrer } from "@/utils/utils";

export default function AboutPage() {
  const { theme } = useTheme();
  const [scrolled, setScrolled] = useState(false);

  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 0);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);
  const [productsOpen, setProductsOpen] = useState(false);

  const productsRef = useRef<HTMLDivElement>(null);

  const isDarkMode = theme === "dark";

  const [dotsOpen, setDotsOpen] = useState(false);
  const dotsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (dotsRef.current && !dotsRef.current.contains(event.target as Node)) {
        setDotsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);
  const [announcementOpen, setAnnouncementOpen] = useState(false);

  useEffect(() => {
    const checkHeight = () => {
      const el = document.querySelector("[data-announcement]") as HTMLElement;
      if (el && el.offsetHeight > 0) {
        setAnnouncementOpen(true);
      } else {
        setAnnouncementOpen(false);
      }
    };
    checkHeight();
    const observer = new MutationObserver(checkHeight);
    observer.observe(document.body, { childList: true, subtree: true });
    return () => observer.disconnect();
  }, []);

  useEffect(() => {
    const checkDismissedAnnouncements = () => {
      const dismissed = getCookie("dismissedAnnouncements");
      if (dismissed) {
        try {
          const dismissedIds = JSON.parse(dismissed);
          if (dismissedIds.length > 0) {
            setAnnouncementOpen(false);
          }
        } catch (error) {
          console.error("Error parsing dismissed announcements:", error);
        }
      }
    };

    checkDismissedAnnouncements();

    const interval = setInterval(checkDismissedAnnouncements, 1000);

    return () => clearInterval(interval);
  }, []);
  return (
    <div className="min-h-screen bg-white dark:bg-[#1a1a1a] ">
      <section className="w-full">
        <section className="relative w-full overflow-hidden">
          <div
            className={`fixed top-0 inset-x-0 z-50 ${
              scrolled
                ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1a1a]/90"
                : productsOpen || dotsOpen
                  ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1a1a]/90"
                  : ""
            }`}
          >
            <div
              ref={(el) => {
                if (el) {
                  const height = el.getBoundingClientRect().height;

                  if (height !== 0) {
                    setAnnouncementOpen(true);
                  }
                }
              }}
            >
              <AnnouncementBar onClose={() => setAnnouncementOpen(false)} />
            </div>
            <div className="container max-w-[1233px] mx-auto max-[1300px]:px-14 max-[1100px]:px-4">
              <nav
                className={`relative flex items-center justify-between py-4`}
              >
                <ClikkleLogo />

                <div className="flex md:hidden items-center">
                  <div
                    className="flex items-center gap-0 rounded-xl border border-gray-300 dark:border-[#ffffff3a] p-[8px] shadow-sm"
                    onClick={toggleLeftDrawer}
                  >
                    <p className="text-sm font-medium text-gray-900 dark:text-white">
                      <Logs className="w-5 h-5 text-gray-900 dark:text-white mr-3" />
                    </p>

                    <p className="flex items-center  rounded-xl text-sm font-bold ">
                      Menu
                    </p>
                  </div>
                </div>

                <div className="hidden md:flex items-center gap-12 font-inter font-medium text-[18px]">
                  <Link
                    href="https://clikkle.com#features"
                    className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                  >
                    Features
                  </Link>
                  <Link
                    href="https://clikkle.com/#pricing"
                    className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                  >
                    Pricing
                  </Link>
                  <Link
                    href="/blogs"
                    className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                  >
                    Blog
                  </Link>
                  <div className="flex flex-row justify-center items-center">
                    <div className="relative" ref={productsRef}>
                      <button
                        onClick={() => setProductsOpen((o) => !o)}
                        className="cursor-pointer flex items-center gap-1 text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                      >
                        Products
                      </button>
                      {productsOpen && (
                        <div
                          className={`fixed ${
                            announcementOpen ? "top-[115px]" : "top-[75px]"
                          } 
              left-1/2 transform -translate-x-1/2 w-full bg-white/90 dark:bg-[#1a1a1a]/90 backdrop-blur-md 
              shadow-lg p-6 border-b-2 border-gray-300 dark:border-[#575662] z-50 flex justify-center items-center pb-0`}
                        >
                          <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                            <div className="flex flex-col gap-3">
                              {apps
                                .slice(0, Math.ceil(apps.length / 2))
                                .map((product) => (
                                  <Link
                                    key={product.id}
                                    href={product.route}
                                    className="flex items-center gap-4 p-[0.35rem] rounded-lg hover:bg-gray-100 dark:hover:bg-white/10 transition"
                                  >
                                    <div>
                                      <Image
                                        src={product.image}
                                        alt={product.title}
                                        className="w-[26px]"
                                        width={26}
                                        height={26}
                                      />
                                    </div>
                                    <div>
                                      <p className="font-bold text-gray-900 dark:text-white text-sm">
                                        {product.title}
                                      </p>
                                      <p className="text-xs text-gray-600 dark:text-gray-300">
                                        {product.description}
                                      </p>
                                    </div>
                                  </Link>
                                ))}
                            </div>

                            <div className="flex flex-col gap-3">
                              {apps
                                .slice(
                                  Math.ceil(apps.length / 2),
                                  Math.ceil(apps.length / 2) + 2,
                                )
                                .map((product) => (
                                  <Link
                                    key={product.id}
                                    href={product.route}
                                    className="flex items-center gap-4 p-[0.35rem] rounded-lg hover:bg-gray-100 dark:hover:bg-white/10 transition"
                                  >
                                    <div>
                                      <Image
                                        src={product.image}
                                        alt={product.title}
                                        className="w-[26px]"
                                        width={26}
                                        height={26}
                                      />
                                    </div>
                                    <div>
                                      <p className="font-bold text-gray-900 dark:text-white text-sm">
                                        {product.title}
                                      </p>
                                      <p className="text-xs text-gray-600 dark:text-gray-300">
                                        {product.description}
                                      </p>
                                    </div>
                                  </Link>
                                ))}

                              <Link href="/products">
                                <Button
                                  style={{ marginTop: "5px" }}
                                  variant="ghost"
                                  className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                >
                                  View all products
                                  <ArrowRightIcon className="h-2 w-2 dark:text-white" />
                                </Button>
                              </Link>
                            </div>

                            <div className="hidden lg:flex flex-row items-center justify-center text-center gap-3">
                              <Image
                                src={illustration}
                                alt="Illustration"
                                className="w-auto h-[175px]"
                              />
                              <div className="flex flex-col justify-center items-center h-full">
                                <p className="text-sm text-gray-700 dark:text-gray-300 max-w-[200px] pb-5">
                                  Get started today the modern solution to power
                                  your business.
                                </p>
                                <Button
                                  variant="ghost"
                                  onClick={() => {
                                    window.location.replace(
                                      `https://worksuite.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`,
                                    );
                                  }}
                                  className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                >
                                  Get Started Today
                                  <ArrowRightIcon
                                    className={`h-2 w-2 dark:text-white`}
                                  />
                                </Button>
                              </div>
                            </div>
                          </div>
                        </div>
                      )}
                    </div>

                    <div className="relative" ref={dotsRef}>
                      <Ellipsis
                        onClick={() => setDotsOpen((o) => !o)}
                        className="w-8 h-6 rounded-full p-[1px] cursor-pointer"
                      />
                      {dotsOpen && (
                        <div
                          className={`fixed ${
                            announcementOpen ? "top-[115px]" : "top-[75px]"
                          }  left-1/2 transform -translate-x-1/2 w-full 
    bg-white/90 dark:bg-[#1a1a1a]/90 backdrop-blur-md 
    shadow-lg border-b-2 border-gray-300 dark:border-[#575662] 
    z-50 flex justify-center`}
                        >
                          <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 py-6">
                            <div className="flex flex-col md:flex-row justify-between items-start gap-12">
                              <div className="space-y-12">
                                <div className="max-w-[285px] space-y-2 mb-0">
                                  <h3 className="font-instrument-sans font-medium text-[18px] leading-[20px] text-gray-900 dark:text-[#eeeef0]">
                                    Get Started For Free
                                  </h3>
                                  <p className="font-body-medium text-[#51515E] dark:text-[#eeeef0]">
                                    Streamline your Business with our Apps.
                                    Effortlessly for every team.
                                  </p>
                                </div>
                                <Button
                                  style={{ marginTop: "20px" }}
                                  variant="ghost"
                                  onClick={() => {
                                    window.location.replace(
                                      `https://worksuite.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`,
                                    );
                                  }}
                                  className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                >
                                  See How It Works
                                  <ArrowRightIcon
                                    className={`h-2 w-2 dark:text-white`}
                                  />
                                </Button>
                              </div>

                              <div className="flex flex-wrap gap-x-14 gap-y-8 text-xs sm:text-sm">
                                {footerColumns.map((column, index) => (
                                  <div
                                    key={index}
                                    className="flex flex-col gap-5"
                                  >
                                    <h4 className="font-label-medium text-gray-900 dark:text-white">
                                      {column.title}
                                    </h4>
                                    <ul className="flex flex-col gap-4">
                                      {column.links.map((link, linkIndex) => (
                                        <li key={linkIndex}>
                                          <div className="flex items-start gap-3">
                                            <Link
                                              href={link.url}
                                              target={
                                                link.url.startsWith("http")
                                                  ? "_blank"
                                                  : "_self"
                                              }
                                              rel={
                                                link.url.startsWith("http")
                                                  ? "noopener noreferrer"
                                                  : undefined
                                              }
                                              className="font-body-medium text-[#51515E] dark:text-[#d7d7de] hover:text-gray-900 dark:hover:text-white transition-colors whitespace-nowrap flex items-center gap-2"
                                            >
                                              {link.text}
                                              {column.title === "Social" && (
                                                <FaArrowRight className="w-2 h-2" />
                                              )}
                                            </Link>

                                            {link.isNew && (
                                              <div className="hidden md:flex items-center gap-2">
                                                <div className="w-4 h-4 flex items-center justify-center">
                                                  <div className="w-[13px] h-[13px] bg-[#c3e6ff] rounded-[6.67px] flex items-center justify-center">
                                                    <div className="w-1 h-1 bg-[#286efb] rounded-sm" />
                                                  </div>
                                                </div>
                                                <span className="font-body-medium text-gray-900 dark:text-white whitespace-nowrap">
                                                  New
                                                </span>
                                              </div>
                                            )}
                                          </div>
                                        </li>
                                      ))}
                                    </ul>
                                  </div>
                                ))}
                              </div>
                            </div>
                          </div>
                        </div>
                      )}
                    </div>
                  </div>
                </div>

                <div className="hidden md:flex items-center gap-4">
                  <div className="hidden md:flex items-center gap-4">
                    <div className="w-6">
                      <ThemeSwitch />
                    </div>
                    <div className="flex items-center gap-2 rounded-xl border border-gray-300 dark:border-[#ffffff3a] p-1 shadow-sm">
                      <button
                        className="cursor-pointer px-3 py-1 text-sm font-medium text-gray-900 dark:text-white"
                        onClick={() => {
                          window.location.replace(
                            `https://worksuite.clikkle.com/login?theme=${theme}&referralApp=${getEncodedReferrer()}`,
                          );
                        }}
                      >
                        Login
                      </button>

                      <button
                        className="cursor-pointer flex items-center gap-1 rounded-xl bg-[#286efb] hover:bg-[#3367d6] px-4 py-1.5 text-sm font-medium text-white transition"
                        onClick={() => {
                          window.location.replace(
                            `https://worksuite.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`,
                          );
                        }}
                      >
                        Try for free
                        <span>
                          <ArrowRightIcon className="w-4" />
                        </span>
                      </button>
                    </div>
                  </div>
                </div>
              </nav>
            </div>
          </div>
        </section>
      </section>

      <section
        className={`px-6 py-28 ${
          announcementOpen ? "pt-[14rem]" : "pt-44"
        }  max-w-7xl mx-auto container`}
      >
        <p className="text-sm text-gray-600 mb-4 dark:text-white font-bold">
          Our mission
        </p>
        <h1 className="text-[28px] md:text-[3rem] font-extrabold text-gray-900 leading-tight mb-8 dark:text-white">
          Empowering <span className="font-bold">anyone </span> to start,
          <br className="hidden sm:block" />
          run and{" "}
          <span className="text-[#286efb] dark:text-[#A9C5FF]">
            grow their business{" "}
          </span>
          <br className="hidden sm:block" />
          from <span className="font-bold"> anywhere</span>.
        </h1>
      </section>

      <section>
        <Image
          src={collage}
          alt="Team collage"
          className="w-full"
          width={1200}
          height={800}
        />
      </section>

      <section className="px-6 mt-20 mb-20">
        <div className="max-w-6xl mx-auto border rounded-xl border-gray-300 dark:border-[#ffffff3a]">
          <div className="grid md:grid-cols-2 gap-12 items-start">
            <div className="px-6 md:pl-10 py-6 md:py-14">
              <p className="text-sm font-extrabold text-gray-600 mb-4 dark:text-white">
                Clikkle Worksuite’s Origin Story
              </p>
              <h2 className="text-[28px] md:text-4xl font-bold text-gray-900 mb-6 dark:text-white">
                 Built to {" "}
                <span className="text-[#286efb] dark:text-[#A9C5FF]">
                  simplify growth.
                </span>
               <br className="hidden sm:block" />
                Sovereign, silo-free business OS.
              </h2>
              <div className="space-y-4 text-gray-700 leading-relaxed dark:text-white">
                <p>
    Every modern organization faces the same exhausting challenge: managing operations across a 
    tangled web of disconnected apps and skyrocketing subscriptions. This is the 
    <span className="font-bold text-gray-900 dark:text-[#A9C5FF]"> &quot;SaaS Tax&quot;</span>—and it’s holding teams back.
  </p>

  <p>
    Fragmented systems—CRM, HR, email marketing, and invoicing—are slow and expensive. 
    At <b>Clikkle Worksuite</b>, we’ve built an ever-expanding ecosystem designed to unify 
    every critical business function under one roof. 
  </p>

  <div className="bg-blue-50 dark:bg-gray-800 p-6 rounded-xl border-l-4 border-[#286efb]">
    <p className="font-bold text-gray-900 dark:text-white mb-2 text-xl">Total Enterprise Data Ownership</p>
    <p className="text-base">
      Unlike competitors who rent third-party servers, Clikkle Worksuite is powered by our proprietary 
      <b> G7 Core Infrastructure</b>. This ensures your business remains 100% sovereign—giving you 
      total ownership of your data on an industrial-grade foundation that others simply can&apos;t replicate.
    </p>
  </div>

  <p>
    We are committed to making growth accessible to every creator. That’s why we are pushing our 
    <b> N5 Suite in 2026</b>—offering essential core features <b>Free Forever</b>. By owning our 
    infrastructure, we pass the savings directly to you, helping you scale without the overhead.
  </p>
                <p>
                  We’re not just building another tool—we’re building the
                  <span className="font-bold">
                    {" "}platform that transforms how businesses run, grow, and
                    succeed.
                  </span>
                </p>

  <p className="mt-8 border-t pt-6 border-gray-200 dark:border-gray-700">
    <b className="text-gray-900 dark:text-white">— The Clikkle Team</b> <br/>
    <span className="text-sm italic text-gray-500 dark:text-gray-400">Built by creators, for creators.</span>
  </p>
</div>
            </div>
            <div className="h-full">
              <Image
                src={Stephan}
                alt="Clikkle "
                className="w-full h-full object-cover relative rotate-[2deg] scale-[1.03] rounded-[14px] shadow-xl"
              />
            </div>
          </div>
        </div>
      </section>

      <section className="px-3 md:px-6 mb-20 relative">
        <div className="max-w-6xl mx-auto">
          <div className="bg-gray-100 dark:bg-[#141414] rounded-2xl p-6 md:p-12 overflow-hidden">
            <div className="grid md:grid-cols-2 gap-8 items-center">
              <div>
                <p className="text-sm opacity-90 mb-4">
                  Power up your workflow
                </p>
                <h2 className="text-[28px] md:text-4xl font-bold mb-6">
                  The ultimate toolkit to
                  <br className="hidden sm:block" />
                  grow your business
                </h2>
                <p className="text-lg opacity-90 mb-8">
                  A simple all-in-one platform to organize projects, share
                  files, manage finances, send invoices, receive payments
                  quickly, and collaborate seamlessly with your team.
                </p>
                <div className="flex gap-4">
                  <button
                    onClick={() => {
                      window.location.replace(
                        "https://worksuite.clikkle.com/signup" +
                          "?theme=" +
                          theme,
                      );
                    }}
                    className="cursor-pointer bg-[white] text-black px-3 py-[12px] rounded-lg h-8 items-center justify-center flex"
                  >
                    Get Started
                  </button>
                  <p className="text-sm opacity-75 self-center">
                    No payment details needed
                  </p>
                </div>
              </div>
              <div>
                <div className="relative">
                  <Image
                    src={theme === "dark" ? workdark : worklight}
                    alt="Dashboard preview"
                    className="w-full h-full shadow-2xl rounded-md blur-[1px]"
                  />

                  <Image
                    src={endorsementImg}
                    alt="Featured callout"
                    className="
        absolute z-20
        -top-6 md:-top-10
        right-4 md:-right-6
        w-20 md:w-36
        rounded-xl
        border-4 border-white
        shadow-2xl
        transform
        md:rotate-3
        "
                  />
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      <Footer />
      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
    </div>
  );
}
