"use client";
import { ArrowDown, ArrowRightIcon, Ellipsis, Logs, Star } from "lucide-react";
import React, { useEffect, useRef, useState } from "react";
import { useTheme } from "../atoms/theme";
import Link from "next/link";
import Image from "next/image";
import Footer from "@/components/Footer";
import SidebarDrawer from "@/components/sidebarDrawer";
import ctaimage from "../../public/images/ctaWhite.png";
import ctaBlack from "../../public/images/ctaBlack.png";
import ThemeSwitch from "@/components/themeSwitch";
import { FaArrowRight } from "react-icons/fa6";
import { Button } from "@/components/button";
import illustration from "../../public/images/new7.png";
import AnnouncementBar from "@/components/AnnouncementBar";
import ClikkleLogo from "@/components/ClikkleLogo";
import { apps } from "../constants/products";
import { footerColumns } from "../constants/footerText";
import { getCookie } from "@/utils/cookies";
import { IoIosCheckmarkCircleOutline } from "react-icons/io";
import { getEncodedReferrer } from "@/utils/utils";

const App = () => {
  const { theme } = useTheme();
  const [leftDrawerOpen, setLeftDrawerOpen] = useState(false);
  const toggleLeftDrawer = () => setLeftDrawerOpen((prev) => !prev);
  const [openFAQ, setOpenFAQ] = useState<number | null>(0);
  const [billing, setBilling] = useState<"monthly" | "yearly">("monthly");
  const isDarkMode = theme === "dark";
  const [scrolled, setScrolled] = useState(false);
  const [announcementOpen, setAnnouncementOpen] = useState(false);

  useEffect(() => {
    const checkHeight = () => {
      const el = document.querySelector("[data-announcement]") as HTMLElement;
      if (el && el.offsetHeight > 0) {
        setAnnouncementOpen(true);
      } else {
        setAnnouncementOpen(false);
      }
    };
    checkHeight();
    const observer = new MutationObserver(checkHeight);
    observer.observe(document.body, { childList: true, subtree: true });
    return () => observer.disconnect();
  }, []);

  useEffect(() => {
    const checkDismissedAnnouncements = () => {
      const dismissed = getCookie("dismissedAnnouncements");
      if (dismissed) {
        try {
          const dismissedIds = JSON.parse(dismissed);
          if (dismissedIds.length > 0) {
            setAnnouncementOpen(false);
          }
        } catch (error) {
          console.error("Error parsing dismissed announcements:", error);
        }
      }
    };

    checkDismissedAnnouncements();

    const interval = setInterval(checkDismissedAnnouncements, 1000);

    return () => clearInterval(interval);
  }, []);
  useEffect(() => {
    const handleScroll = () => {
      setScrolled(window.scrollY > 0);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const testimonialColorMap = [
    "bg-emerald-100 text-emerald-800",
    "bg-blue-100 text-blue-800",
    "bg-violet-100 text-violet-800",
    "bg-amber-100 text-amber-800",
    "bg-rose-100 text-rose-800",
    "bg-lime-100 text-lime-800",
    "bg-purple-100 text-purple-800",
    "bg-indigo-100 text-indigo-800",
    "bg-green-100 text-green-800",
    "bg-pink-100 text-pink-800",
    "bg-gray-100 text-gray-800",
  ];

  const testimonials = [
    {
      id: 1,
      name: "Ameen R.",
      title: "Founder • Creative Studio",
      avatar: "AR",
      quote:
        "This tool instantly simplified how we work with clients. Everything is organized, easy to access, and looks professional without any setup headache.",
    },
    {
      id: 2,
      name: "Sarah K.",
      title: "Product Manager",
      avatar: "SK",
      quote:
        "Communication, files, and tasks finally live in one place. My clients understand it immediately, which saves us a lot of back-and-forth.",
    },
    {
      id: 3,
      name: "Hassan M.",
      title: "Freelance Designer",
      avatar: "HM",
      quote:
        "Perfect for freelancers. Clean interface, smooth workflow, and clients love the experience. It makes my brand feel more premium.",
    },
    {
      id: 4,
      name: "Olivia D.",
      title: "CEO • Marketing Agency",
      avatar: "OD",
      quote:
        "We replaced three different tools with this one. Projects move faster, and clients stay informed without constant follow-ups.",
    },
    {
      id: 5,
      name: "Daniel P.",
      title: "Startup Founder",
      avatar: "DP",
      quote:
        "Simple, powerful, and intuitive. It took us minutes to get started and immediately improved how we collaborate internally and externally.",
    },
    {
      id: 6,
      name: "Fatima Z.",
      title: "Operations Lead",
      avatar: "FZ",
      quote:
        "What I love most is clarity. Everyone knows what’s happening, what’s next, and where to find things—no confusion.",
    },
    {
      id: 7,
      name: "Usman A.",
      title: "CTO • SaaS Startup",
      avatar: "UA",
      quote:
        "The experience feels thoughtfully designed. From onboarding to daily usage, everything flows naturally without needing documentation.",
    },
    {
      id: 8,
      name: "Emily R.",
      title: "Client Success Manager",
      avatar: "ER",
      quote:
        "Our clients adopted it instantly. Fewer emails, clearer communication, and a noticeable improvement in satisfaction.",
    },
    {
      id: 9,
      name: "Bilal K.",
      title: "Agency Owner",
      avatar: "BK",
      quote:
        "It helped us look more professional overnight. The portal feels premium and builds trust with new clients immediately.",
    },
    {
      id: 10,
      name: "Noah T.",
      title: "Product Designer",
      avatar: "NT",
      quote:
        "Minimal, fast, and pleasant to use. It removes friction instead of adding features for the sake of it.",
    },
    {
      id: 11,
      name: "Ayesha S.",
      title: "Project Coordinator",
      avatar: "AS",
      quote:
        "Tracking progress and sharing updates has become effortless. Everyone stays aligned without constant reminders.",
    },
    {
      id: 12,
      name: "Mark L.",
      title: "Founder • Digital Studio",
      avatar: "ML",
      quote:
        "This is one of those tools you don’t realize you needed until you use it. Now we can’t imagine working without it.",
    },
  ];

  const faqs = [
    {
      question: "Can I pay the lifetime plans in installments?",
      answer:
        "Yes, you can choose to pay in installments for both Lifetime 5 and Lifetime Unlimited plans. This option allows you to spread the cost over time while still enjoying all the benefits of our lifetime plans.",
    },
    {
      question: "Do I get access to all features with the lifetime plans?",
      answer:
        "Absolutely! Both lifetime plans include access to every feature available in Kitchen.co, including unlimited clients, folders, storage, white-label capabilities, custom domains, advanced branding, unbranded emails, tasks & boards, file management, chats, docs, invoices, client portal, and more.",
    },
    {
      question: "Are future updates included too?",
      answer:
        "Yes, both lifetime plans include every future update we release. You'll continue to receive new features, improvements, and enhancements as we develop them, ensuring your investment remains valuable over time.",
    },
    {
      question: "Can I buy more storage if I need it?",
      answer:
        "Both lifetime plans include 500GB of storage (5GB per file). If you require additional storage beyond this limit, please contact our support team to discuss custom storage options for your specific needs.",
    },
    {
      question: "What forms of payment do you accept?",
      answer:
        "We accept all major credit cards (Visa, Mastercard, American Express, Discover) and PayPal for payment. For installment payments, we use Stripe to securely process your recurring payments.",
    },
  ];

  const heroContent = {
    title: "Simple Pricing for Everyone",
    subtitle:
      "Choose monthly or yearly plans. Upgrade anytime. No hidden charges.",
    tagline: "Simple, transparent, and affordable pricing for everyone.",
  };

  const pricingPlans = [
    {
      id: "starter",
      name: "Starter",
      description: "Perfect for individuals & personal use",
      users: "1 user",
      monthly: 9,
      yearly: 90,
      features: [
        "Access to core app features",
        "Basic AI processing",
        "Standard text-to-speech voices",
        "Language support (EN, AR, UR, HI)",
        "Offline mode (limited)",
        "Basic speed & pitch controls",
        "Save up to 50 files",
        "Limited storage (5 GB)",
        "Single-device usage",
        "Basic analytics (usage stats)",
        "Email support (48h response)",
        "Standard app updates",
        "Basic security & encryption",
        "Community access",
        "Ads-free experience",
      ],
    },
    {
      id: "pro",
      name: "Pro",
      description: "Best for power users, teams & creators",
      users: "Up to 10 users",
      monthly: 19,
      yearly: 190,
      highlighted: true,
      features: [
        "Everything in Starter",
        "Advanced AI voice quality",
        "Premium natural voices",
        "Unlimited text-to-speech conversions",
        "Full offline mode",
        "Advanced speed, pitch & tone controls",
        "Save unlimited files",
        "Unlimited cloud storage",
        "Multi-device sync",
        "Team collaboration & shared folders",
        "Advanced analytics & insights",
        "Priority support (24h response)",
        "Early access to new features",
        "Custom themes & UI personalization",
        "No usage limits",
        "Higher performance processing",
        "Export in multiple audio formats",
      ],
    },
    {
      id: "enterprise",
      name: "Enterprise",
      description: "Built for businesses & large organizations",
      users: "Unlimited users",
      monthly: 39,
      yearly: 390,
      features: [
        "Access to core app features",
        "Basic AI processing",
        "Standard text-to-speech voices",
        "Language support (EN, AR, UR, HI)",
        "Offline mode (limited)",
        "Basic speed & pitch controls",
        "Save up to 50 files",
        "Limited storage (5 GB)",
        "Single-device usage",
        "Basic analytics (usage stats)",
        "Email support (48h response)",
        "Standard app updates",
        "Basic security & encryption",
        "Community access",
        "Ads-free experience",
      ],
    },
  ];

  function getTestimonialColor(index: number) {
    return testimonialColorMap[index % testimonialColorMap.length];
  }

  const [productsOpen, setProductsOpen] = useState(false);
  const [dotsOpen, setDotsOpen] = useState(false);
  const productsRef = useRef<HTMLDivElement>(null);
  const dotsRef = useRef<HTMLDivElement>(null);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (
        productsRef.current &&
        !productsRef.current.contains(event.target as Node)
      ) {
        setProductsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);

  useEffect(() => {
    function handleClickOutside(event: MouseEvent) {
      if (dotsRef.current && !dotsRef.current.contains(event.target as Node)) {
        setDotsOpen(false);
      }
    }
    document.addEventListener("mousedown", handleClickOutside);
    return () => document.removeEventListener("mousedown", handleClickOutside);
  }, []);
  return (
    <div className="min-h-screen bg-white dark:bg-[#1a1a1a]">
      <section className="w-full">
        <section className="relative w-full overflow-hidden">
          <div
            className={`fixed top-0 inset-x-0 z-50 ${
              scrolled
                ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1a1a]/90"
                : productsOpen || dotsOpen
                ? "backdrop-blur-md bg-white/90 dark:bg-[#1a1a1a]/90"
                : ""
            }`}
          >
            <div
              ref={(el) => {
                if (el) {
                  const height = el.getBoundingClientRect().height;

                  if (height !== 0) {
                    setAnnouncementOpen(true);
                  }
                }
              }}
            >
              <AnnouncementBar onClose={() => setAnnouncementOpen(false)} />
            </div>
            <div className="container max-w-[1233px] mx-auto max-[1300px]:px-14 max-[1100px]:px-4">
              <nav
                className={`relative flex items-center justify-between py-4`}
              >
                <ClikkleLogo />

                <div className="flex md:hidden items-center">
                  <div
                    className="flex items-center gap-0 rounded-xl border border-gray-300 dark:border-[#ffffff3a] p-[8px] shadow-sm"
                    onClick={toggleLeftDrawer}
                  >
                    <p className="text-sm font-medium text-gray-900 dark:text-white">
                      <Logs className="w-5 h-5 text-gray-900 dark:text-white mr-3" />
                    </p>

                    <p className="flex items-center  rounded-xl text-sm font-bold ">
                      Menu
                    </p>
                  </div>
                </div>

                <div className="hidden md:flex items-center gap-12  font-inter font-medium text-[18px]">
                  <Link
                    href="#features"
                    className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                  >
                    Features
                  </Link>
                  <Link
                    href="https://clikkle.com/#pricing"
                    className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                  >
                    Pricing
                  </Link>
                  <Link
                    href="/blogs"
                    className="text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                  >
                    Blog
                  </Link>
                  <div className="flex flex-row justify-center items-center">
                    <div className="relative" ref={productsRef}>
                      <button
                        onClick={() => setProductsOpen((o) => !o)}
                        className="cursor-pointer flex items-center gap-1 text-gray-900 dark:text-white hover:text-gray-600 dark:hover:text-[#d7d7de] transition-colors"
                      >
                        Products
                      </button>
                      {productsOpen && (
                        <div
                          className={`fixed ${
                            announcementOpen ? "top-[115px]" : "top-[75px]"
                          } 
              left-1/2 transform -translate-x-1/2 w-full bg-white/90 dark:bg-[#1a1a1a]/90 backdrop-blur-md 
              shadow-lg p-6 border-b-2 border-gray-300 dark:border-[#575662] z-50 flex justify-center items-center pb-0`}
                        >
                          <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                      <div className="flex flex-col gap-3">
                              {apps
                                .slice(0, Math.ceil(apps.length / 2))
                                .map((product) => (
                                  <Link
                                    key={product.id}
                                    href={product.route}
                                    className="flex items-center gap-4 p-[0.35rem] rounded-lg hover:bg-gray-100 dark:hover:bg-white/10 transition"
                                  >
                                    <div>
                                      <Image
                                        src={product.image}
                                        alt={product.title}
                                        className="w-[26px]"
                                        width={26}
                                        height={26}
                                      />
                                    </div>
                                    <div>
                                      <p className="font-bold text-gray-900 dark:text-white text-sm">
                                        {product.title}
                                      </p>
                                      <p className="text-xs text-gray-600 dark:text-gray-300">
                                        {product.description}
                                      </p>
                                    </div>
                                  </Link>
                                ))}
                            </div>

                            <div className="flex flex-col gap-3">
                              {apps
                                .slice(
                                  Math.ceil(apps.length / 2),
                                  Math.ceil(apps.length / 2) + 2,
                                )
                                .map((product) => (
                                  <Link
                                    key={product.id}
                                    href={product.route}
                                    className="flex items-center gap-4 p-[0.35rem] rounded-lg hover:bg-gray-100 dark:hover:bg-white/10 transition"
                                  >
                                    <div>
                                      <Image
                                        src={product.image}
                                        alt={product.title}
                                        className="w-[26px]"
                                        width={26}
                                        height={26}
                                      />
                                    </div>
                                    <div>
                                      <p className="font-bold text-gray-900 dark:text-white text-sm">
                                        {product.title}
                                      </p>
                                      <p className="text-xs text-gray-600 dark:text-gray-300">
                                        {product.description}
                                      </p>
                                    </div>
                                  </Link>
                                ))}
                              <Link href="/products">
                                <Button
                                  style={{ marginTop: "5px" }}
                                  variant="ghost"
                                  className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                >
                                  View all products
                                  <ArrowRightIcon className="h-2 w-2 dark:text-white" />
                                </Button>
                              </Link>
                            </div>
                            <div className="hidden lg:flex flex-row items-center justify-center text-center gap-3">
                              <Image
                                src={illustration}
                                alt="Illustration"
                                className="w-auto h-[175px]"
                                width={400}
                                height={175}
                              />
                              <div className="flex flex-col justify-center items-center h-full">
                                <p className="text-sm text-gray-700 dark:text-gray-300 max-w-[200px] pb-5">
                                  Get started today the modern solution to power
                                  your business.
                                </p>
                                <Button
                                  variant="ghost"
                                  onClick={() => {
                                    window.location.replace(
                                      `https://worksuite.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`
                                    );
                                  }}
                                  className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                >
                                  Get Started Today
                                  <ArrowRightIcon
                                    className={`h-2 w-2 dark:text-white`}
                                  />
                                </Button>
                              </div>
                            </div>
                          </div>
                        </div>
                      )}
                    </div>

                    <div className="relative" ref={dotsRef}>
                      <Ellipsis
                        onClick={() => setDotsOpen((o) => !o)}
                        className="w-8 h-6 rounded-full p-[1px] cursor-pointer"
                      />
                      {dotsOpen && (
                        <div
                          className={`fixed ${
                            announcementOpen ? "top-[115px]" : "top-[75px]"
                          } } left-1/2 transform -translate-x-1/2 w-full 
    bg-white/90 dark:bg-[#1a1a1a]/90 backdrop-blur-md 
    shadow-lg border-b-2 border-gray-300 dark:border-[#575662] 
    z-50 flex justify-center`}
                        >
                          <div className="container max-w-[1233px] max-[1300px]:px-14 max-[1100px]:px-4 py-6">
                            <div className="flex flex-col md:flex-row justify-between items-start gap-12">
                              <div className="space-y-12">
                                <div className="max-w-[285px] space-y-2 mb-0">
                                  <h3 className="font-instrument-sans font-medium text-[18px] leading-[20px] text-gray-900 dark:text-[#eeeef0]">
                                    Get Started For Free
                                  </h3>
                                  <p className="font-body-medium text-[#51515E] dark:text-[#eeeef0]">
                                    Streamline your Business with our Apps.
                                    Effortlessly for every team.
                                  </p>
                                </div>
                                <Button
                                  style={{ marginTop: "20px" }}
                                  variant="ghost"
                                  onClick={() => {
                                    window.location.replace(
                                      `https://worksuite.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`
                                    );
                                  }}
                                  className={`cursor-pointer hover:bg-[#286efb] w-44 hover:dark:bg-[#286efb] hover:text-white hover:dark:text-[#eeeef0] font-inter font-[800] text-[12px] leading-[16px] tracking-[0em] rounded-2xl text-xs gap-1 px-4 py-2 h-auto bg-[#F3F4F6] dark:bg-[#1a1a1a] text-gray-900 dark:text-[#eeeef0] border border-solid border-[#8f8f8f] dark:border-[#ffffff33]`}
                                >
                                  See How It Works
                                  <ArrowRightIcon
                                    className={`h-2 w-2 dark:text-white`}
                                  />
                                </Button>
                              </div>

                              <div className="flex flex-wrap gap-x-14 gap-y-8 text-xs sm:text-sm">
                                {footerColumns.map((column, index) => (
                                  <div
                                    key={index}
                                    className="flex flex-col gap-5"
                                  >
                                    <h4 className="font-label-medium text-gray-900 dark:text-white">
                                      {column.title}
                                    </h4>
                                    <ul className="flex flex-col gap-4">
                                      {column.links.map((link, linkIndex) => (
                                        <li key={linkIndex}>
                                          <div className="flex items-start gap-3">
                                            <Link
                                              href={link.url}
                                              target={
                                                link.url.startsWith("http")
                                                  ? "_blank"
                                                  : "_self"
                                              }
                                              rel={
                                                link.url.startsWith("http")
                                                  ? "noopener noreferrer"
                                                  : undefined
                                              }
                                              className="font-body-medium text-[#51515E] dark:text-[#d7d7de] hover:text-gray-900 dark:hover:text-white transition-colors whitespace-nowrap flex items-center gap-2"
                                            >
                                              {link.text}
                                              {column.title === "Social" && (
                                                <FaArrowRight className="w-2 h-2" />
                                              )}
                                            </Link>

                                            {link.isNew && (
                                              <div className="hidden md:flex items-center gap-2">
                                                <div className="w-4 h-4 flex items-center justify-center">
                                                  <div className="w-[13px] h-[13px] bg-[#c3e6ff] rounded-[6.67px] flex items-center justify-center">
                                                    <div className="w-1 h-1 bg-[#286efb] rounded-sm" />
                                                  </div>
                                                </div>
                                                <span className="font-body-medium text-gray-900 dark:text-white whitespace-nowrap">
                                                  New
                                                </span>
                                              </div>
                                            )}
                                          </div>
                                        </li>
                                      ))}
                                    </ul>
                                  </div>
                                ))}
                              </div>
                            </div>
                          </div>
                        </div>
                      )}
                    </div>
                  </div>
                </div>

                <div className="hidden md:flex items-center gap-4">
                  <div className="hidden md:flex items-center gap-4">
                    <div className="w-6">
                      <ThemeSwitch />
                    </div>
                    <div className="flex items-center gap-2 rounded-xl border border-gray-300 dark:border-[#ffffff3a] p-1 shadow-sm">
                      <button
                        className="cursor-pointer px-3 py-1 text-sm font-medium text-gray-900 dark:text-white"
                        onClick={() => {

                          window.location.replace(
                            `https://worksuite.clikkle.com/login?theme=${theme}&referralApp=${getEncodedReferrer()}`
                          );
                        }}
                      >
                        Login
                      </button>

                      <button
                        className="cursor-pointer flex items-center gap-1 rounded-xl bg-[#286efb] hover:bg-[#3367d6] px-4 py-1.5 text-sm font-medium text-white transition"
                        onClick={() => {

                          window.location.replace(
                            `https://worksuite.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`
                          );
                        }}
                      >
                        Try for free
                        <span>
                          <ArrowRightIcon className="w-4" />
                        </span>
                      </button>
                    </div>
                  </div>
                </div>
              </nav>
            </div>
          </div>
        </section>
      </section>
      <header
        className={`${
          announcementOpen ? "pt-[140px]" : "pt-[110px]"
        } py-6 px-4 md:px-8 flex justify-center`}
      >
        <div className="flex items-center">
          <Image
            alt="Clikkle Technologies logo"
            width={114}
            height={40}
            className="h-[32px] md:h-[40px] w-auto" 
            src={
              isDarkMode
                ? "https://cdn.clikkle.com/images/worksuite/2025/Clikkle%20Worksuite%20Blue%20(%20White%20Text).png"
                : "https://cdn.clikkle.com/images/worksuite/2025/Clikkle%20Worksuite%20Blue%20(%20Black%20Text).png"
            }
          />
        </div>
      </header>
      <section className="py-10 px-4 md:px-8 max-w-6xl mx-auto">
        <div className="text-center mb-10">
          <h6 className=" font-body-medium mb-8">{heroContent.tagline}</h6>
          <h2 className="text-5xl md:text-7xl font-extrabold mb-4 max-w-[500px] mx-auto ">
            {heroContent.title}
          </h2>
          <p className="text-normal md:text-2xl text-[#51515E] dark:text-[#D7D7DE]">
            {heroContent.subtitle}
          </p>

          <div className="flex justify-center mt-6">
            <div className="inline-flex rounded-full border border-gray-300 dark:border-[#ffffff3a] bg-gray-100 dark:bg-[#1a1a1a] p-1 my-4">
              {["monthly", "yearly"].map((type) => (
                <button
                  key={type}
                  onClick={() => setBilling(type as "monthly" | "yearly")}
                  className={`cursor-pointer px-6 py-2 text-sm font-medium rounded-full transition-all duration-300
          ${
            billing === type
              ? "bg-[#4072f5] text-white shadow-md"
              : "text-gray-700 dark:text-gray-300 hover:bg-white/70 dark:hover:bg-white/10"
          }
        `}
                >
                  {type === "monthly" ? "Monthly" : "Yearly"}
                </button>
              ))}
            </div>
          </div>
        </div>

        <div className="grid md:grid-cols-3 gap-8 items-end">
          {pricingPlans.map((plan) => {
            const price = billing === "monthly" ? plan.monthly : plan.yearly;

            return (
              <div
                key={plan.id}
                className={`relative flex flex-col rounded-xl p-6 transition border
          border-gray-300 dark:border-[#ffffff3a]
          ${
            plan.highlighted
              ? "bg-[#1a1a1a] dark:bg-black text-white shadow-xl scale-105 min-h-[560px]"
              : "bg-white dark:bg-[#1a1a1a] min-h-[500px]"
          }
        `}
              >
                <div>
                  {plan.highlighted && (
                    <span className="absolute -top-3 left-1/2 -translate-x-1/2 bg-[#4072f5] text-white text-xs px-3 py-1 rounded-full">
                      Most Popular
                    </span>
                  )}

                  <h3 className="text-2xl font-bold mb-2">{plan.name}</h3>

                  <p
                    className={`text-sm mb-4 ${
                      plan.highlighted
                        ? "text-gray-300"
                        : "text-[#51515E] dark:text-[#D7D7DE]"
                    }`}
                  >
                    {plan.description}
                  </p>

                  <div className="mb-4">
                    <div className="text-4xl font-bold">
                      ${price}
                      <span className="text-sm font-normal">
                        /{billing === "monthly" ? "mo" : "yr"}
                      </span>
                    </div>
                    <div className="text-sm opacity-80">{plan.users}</div>
                  </div>

                  <button
                    className={`w-full py-2 rounded-md font-medium mb-6 ${
                      plan.highlighted
                        ? "bg-[#4072f5] hover:bg-[#3366cc] text-white"
                        : "bg-black text-white hover:bg-gray-800"
                    }`}
                  >
                    Get Started
                  </button>
                </div>
                <ul className="space-y-2 text-sm mt-auto">
                  {plan.features.map((feature, i) => (
                    <li key={i} className="flex gap-2 items-center">
                      <IoIosCheckmarkCircleOutline />
                      {feature}
                    </li>
                  ))}
                </ul>
              </div>
            );
          })}
        </div>
      </section>

      <section className="py-12 px-4 md:px-8 bg-white dark:bg-[#1a1a1a]">
        <div className="max-w-6xl mx-auto">
          <h2 className="text-3xl md:text-4xl font-bold text-center mb-12">
            Here&apos;s What Our Lifetime
            <br />
            Clients Are Saying
          </h2>

          <div className="grid md:grid-cols-3 gap-6">
            {testimonials.map((testimonial, index) => (
              <div
                key={testimonial.id}
                className="bg-white dark:bg-[#1a1a1a] border border-gray-300 dark:border-[#ffffff3a] rounded-lg p-6"
              >
                <div className="flex items-center mb-4">
                  {[...Array(5)].map((_, i) => (
                    <Star
                      key={i}
                      className="w-4 h-4 text-yellow-400 fill-current"
                    />
                  ))}
                </div>
                <p className="mb-4 italic">&quot;{testimonial.quote}&quot;</p>
                <div className="flex items-center">
                  <div
                    className={`w-10 h-10 rounded-full ${getTestimonialColor(
                      index
                    )} flex items-center justify-center font-semibold text-sm`}
                  >
                    {testimonial.avatar}
                  </div>
                  <div className="ml-3">
                    <div className="font-semibold">{testimonial.name}</div>
                    <div className="text-sm text-[#51515E] dark:text-[#D7D7DE]">
                      {testimonial.title}
                    </div>
                  </div>
                </div>
              </div>
            ))}
          </div>
        </div>
      </section>
      <section className="w-full">
        <section className="w-full py-20 md:py-32 bg-white dark:bg-[#1a1a1a]">
          <div className="container max-w-[694px] mx-auto px-4  text-center">
            <span className="text-gray-900 dark:text-white text-center font-bold text-sm">
              FAQS SECTION
            </span>
            <div className="text-center mb-24 mt-8">
              <h2 className="text-[32px]  [text-stroke:1px_#000] font-boldmd:text-5xl font-medium text-gray-900 dark:text-white mb-6 font-paragraph-inter-m-regular">
                Frequently Asked Questions
              </h2>
            </div>
            <div className="space-y-4 border border-gray-300 dark:border-[#5e5e69] rounded-xl overflow-hidden transition-colors bg-gray-100 dark:bg-[#141414] p-2">
              {faqs.map((faq, index) => {
                const isOpen = openFAQ === index;
                return (
                  <React.Fragment key={index}>
                    <div
                      className={`rounded-xl overflow-hidden transition-colors !mt-[0px] ${
                        isOpen
                          ? "bg-white dark:bg-[#1a1a1a]"
                          : "bg-gray-100 dark:bg-[#141414]"
                      }`}
                    >
                      <button
                        className="w-full px-4 py-5 text-left flex items-center justify-between hover:bg-white dark:hover:bg-[#1a1a1a] transition-colors"
                        onClick={() => setOpenFAQ(isOpen ? null : index)}
                      >
                        <h3 className="text-lg font-[400] text-gray-900 dark:text-white pr-4">
                          {faq.question}
                        </h3>
                        <ArrowDown
                          className={`w-6 h-6 text-black bg-gray-300 dark:bg-[#d7d7de] rounded-full p-1 font-bold transition-transform ${
                            isOpen ? "rotate-180" : ""
                          }`}
                        />
                      </button>

                      {isOpen && (
                        <div className="pr-8 pl-4 pb-6">
                          <p className="text-[#51515E] dark:text-[#EEEEF0] text-start font-[300] text-md">
                            {faq.answer}
                          </p>
                        </div>
                      )}
                    </div>
                    {index < 4 && (
                      <hr className="h-px bg-gray-300 dark:bg-[#5e5e69] border-0 !m-[5px]" />
                    )}
                  </React.Fragment>
                );
              })}
            </div>
          </div>
        </section>
      </section>
      <section className="w-full flex justify-center items-center">
        <div className="bg-[#edeef1] dark:bg-[#141414] p-10 md:pt-10 pt-16 rounded-[20px] border-2 border-dashed border-gray-300 dark:border-[#575662] my-24 mx-[1.2rem] md:mx-[50px] md:max-w-[1062px] relative overflow-hidden md:overflow-visible">
          <div className="flex flex-col-reverse md:flex-row items-center md:items-start h-full">
            <div className="w-full text-center md:text-left flex flex-col justify-between gap-4 h-full md:w-[1062px] pt-36 md:pt-0">
              <div>
                <h2 className="!text-[30px] md:!text-[55px] leading-none font-bold text-gray-900 dark:text-white">
                  Simplify{" "}
                  <span className="text-[#286efb] dark:text-[#a9c5ff]">
                    Processes
                  </span>
                </h2>
                <h3 className="!text-[30px] md:!text-[55px] font-bold text-gray-900 dark:text-white leading-tight">
                  Boost Productivity
                </h3>
              </div>

              <p className="mt-4 text-gray-600 dark:text-gray-300 text-base md:text-lg">
                Manage Organizations efficiently with powerful tools and{" "}
                <br className="hidden sm:block" />
                collaborate seamlessly, anywhere, anytime.
              </p>

              <div className="mt-6 w-full max-w-xl flex flex-col items-center md:items-start gap-4">
                <div className="flex flex-col sm:flex-row items-center sm:items-stretch gap-3 w-full">
                  <input
                    type="email"
                    placeholder="Enter Your Email"
                    className="flex-1 px-4 py-3 rounded-lg bg-white text-gray-900 placeholder-gray-500 dark:placeholder-gray-400 focus:outline-none w-full border border-gray-300 dark:border-[#575662] shadow-sm dark:shadow-none"
                  />
                  <button
                    onClick={() => {
                      window.location.replace(
                        `https://worksuite.clikkle.com/signup?theme=${theme}&referralApp=${getEncodedReferrer()}`
                      );
                    }}
                    className="cursor-pointer px-6 py-3 bg-black dark:bg-[#286efb] text-white font-medium rounded-lg transition w-full sm:w-auto"
                  >
                    Get Started for Free
                  </button>
                </div>

                <div className="flex items-start gap-2 text-sm text-gray-600 dark:text-gray-300">
                  <label className="relative flex items-center h-full cursor-pointer">
                    <input
                      type="checkbox"
                      id="terms"
                      aria-label="Agree to terms and conditions"
                      defaultChecked
                      className="peer appearance-none h-4 w-4 border-2 border-blue-500 rounded-full bg-white dark:bg-gray-800 checked:bg-[#286efb] checked:border-blue-500 checked:ring-2 checked:ring-blue-300 transition duration-200"
                    />
                    <span className="absolute left-0 top-0 h-4 w-4 flex items-center justify-center pointer-events-none peer-checked:before:content-['✓'] peer-checked:before:text-white peer-checked:before:text-sm peer-checked:before:font-bold"></span>
                  </label>

                  <span className="ml-1 leading-5">
                    I agree with the{" "}
                    <Link
                      href="/terms-of-service"
                      className="underline text-gray-900 dark:text-gray-100 hover:text-[#51515E] dark:hover:text-white"
                      target="_blank"
                      rel="noopener noreferrer"
                    >
                      Terms and Conditions
                    </Link>
                  </span>
                </div>
              </div>
            </div>

            <div className="w-full md:w-1/2 md:h-full md:self-end flex md:justify-end md:items-end justify-center items-center relative">
              <Image
                src={theme === "dark" ? ctaBlack : ctaimage}
                alt="eSignature Illustration"
                className="w-[11.5rem] sm:w-[13rem] md:w-[340px] absolute left-1/2 md:left-auto top-[-48px] md:top-auto md:bottom-[-42px] md:right-[-35px] -translate-x-1/2 md:translate-x-0 z-10 pointer-events-none"
                width={340}
                height={400}
              />
            </div>
          </div>
        </div>
      </section>
      <Footer />
      <SidebarDrawer open={leftDrawerOpen} toggle={toggleLeftDrawer} />
    </div>
  );
};

export default App;
