import WorksuiteHomeComponent from "../../clikklepages/worksuiteHome";
import { Metadata } from "next";
export const metadata: Metadata = {
  title: "Clikkle Worksuite | Business Apps And Collaboration Tools",
  description:
    "Transform your business with Clikkle's comprehensive suite. CRM, HR management, project tracking, file sharing, e-signature, team chat, and collaboration tools all in one powerful platform. Start your free trial today!",
  keywords:
    "business suite, all-in-one software, CRM, HR management, project management, file sharing, e-signature, team collaboration, business tools, productivity software, business automation",
  openGraph: {
    title: "Clikkle Worksuite | Business Apps And Collaboration Tools",
    description:
      "Transform your business with Clikkle's comprehensive suite. CRM, HR, project management, and collaboration tools all in one platform.",
    url: "https://clikkle.com",
    siteName: "Clikkle",
    images: [
      {
        url: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle Business Suite Platform - All Your Business Tools in One Place",
      },
    ],
    locale: "en_US",
    type: "website",
  },
  twitter: {
    card: "summary_large_image",
    title: "Clikkle Worksuite | Business Apps And Collaboration Tools",
    description:
      "Transform your business with Clikkle's comprehensive suite. All your business tools in one powerful platform.",
    images: [
      "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
    ],
  },
  alternates: {
    canonical: "https://clikkle.com",
  },
  icons: {
    icon: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
    apple:
      "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
  },
};
export default function WorksuiteHome() {
  return <WorksuiteHomeComponent />;
}
