import { Metadata } from "next";
import TermOfServiceComponent from "../../clikklepages/termOfService";

export const metadata: Metadata = {
  title: "Terms of Service | Clikkle Business Suite - Legal Terms",
  description: "Review Clikkle's terms of service for using our business suite. Understand your rights, responsibilities, and the legal terms governing our CRM, HR, project management, and other business tools.",
  keywords: "terms of service, legal terms, business software terms, clikkle terms, service agreement, user agreement, business suite terms, legal agreement",
  openGraph: {
    title: "Terms of Service | Clikkle Business Suite - Legal Terms",
    description: "Review Clikkle's terms of service for using our business suite. Understand your rights and responsibilities.",
    url: "https://clikkle.com/terms-of-service",
    images: [
      {
        url: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle Terms of Service",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Terms of Service | Clikkle Business Suite - Legal Terms",
    description: "Review Clikkle's terms of service for using our business suite.",
    images: ["https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png"],
  },
  alternates: {
    canonical: "https://clikkle.com/terms-of-service",
  },
  icons: {
    icon: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
    apple: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
  },
};

export default function TermsOfServiceHome() {
  return <TermOfServiceComponent />;
}