import { Metadata } from "next";
import ComingSoon from "@/clikklepages/comingSoon";

export const metadata: Metadata = {
  title: "Clikkle | Customer Support Software | Help Desk System",
  description: "Deliver exceptional customer support with Clikkle's support software. Ticket management, help desk system, customer service tools, and comprehensive support analytics to improve customer satisfaction.",
  keywords: "customer support software, help desk system, ticket management, customer service, support tools, help desk software, customer support platform, support analytics",
  openGraph: {
    title: "Clikkle | Customer Support Software | Help Desk System",
    description: "Deliver exceptional customer support with Clikkle's support software. Ticket management and help desk system.",
    url: "https://clikkle.com/support",
    images: [
      {
        url: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle Customer Support Dashboard",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Clikkle | Customer Support Software | Help Desk System",
    description: "Deliver exceptional customer support with Clikkle's support platform.",
    images: ["https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png"],
  },
  alternates: {
    canonical: "https://clikkle.com/support",
  },
  icons: {
    icon: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
    apple: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
  },
};

export default function SupportHome() {
      return (
        <ComingSoon/>
    )
}