import { Metadata } from "next";
import ComingSoon from "@/clikklepages/comingSoon";

export const metadata: Metadata = {
  title: "Clikkle SMS | SMS Marketing Software | Business Text Messaging",
  description: "Reach customers instantly with Clikkle's SMS marketing software. Send bulk text messages, automate SMS campaigns, track delivery rates, and engage customers with our powerful business texting platform.",
  keywords: "SMS marketing, text messaging software, bulk SMS, business texting, SMS campaigns, text message marketing, SMS automation, business SMS",
  openGraph: {
    title: "Clikkle SMS | SMS Marketing Software | Business Text Messaging",
    description: "Reach customers instantly with Clikkle's SMS marketing software. Send bulk text messages and automate SMS campaigns.",
    url: "https://clikkle.com/sms",
    images: [
      {
        url: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle SMS Marketing Dashboard",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Clikkle SMS | SMS Marketing Software | Business Text Messaging",
    description: "Reach customers instantly with Clikkle's SMS marketing platform.",
    images: ["https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png"],
  },
  alternates: {
    canonical: "https://clikkle.com/sms",
  },
  icons: {
    icon: "https://cdn.clikkle.com/images/sms/logo/2025/clikkle%20sms.png",
    apple: "https://cdn.clikkle.com/images/sms/logo/2025/clikkle%20sms.png",
  },
};

export default function SMSHome() {
     return (
        <ComingSoon/>
    )
}