import { Metadata } from "next";
import HrHomePage from "../../clikklepages/hrHome";

export const metadata: Metadata = {
  title: "Clikkle HR | HR Management Software | Human Resources System",
  description:
    "Transform your HR operations with Clikkle's comprehensive HR management software. Streamline employee onboarding, track performance, manage payroll, and automate HR processes with our powerful human resources platform.",
  keywords:
    "HR software, human resources management, employee onboarding, payroll management, performance tracking, HR automation, workforce management, employee database",
  openGraph: {
    title: "Clikkle HR | HR Management Software | Human Resources System",
    description:
      "Streamline HR operations with Clikkle's HR management software. Employee onboarding, payroll, and performance tracking.",
    url: "https://clikkle.com/hr",
    images: [
      {
        url: "https://cdn.clikkle.com/images/hr/logo/2025/clikkle%20hr.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle HR Management Dashboard",
      },
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Clikkle HR | HR Management Software | Human Resources System",
    description:
      "Streamline HR operations with Clikkle's comprehensive HR management platform.",
    images: ["https://cdn.clikkle.com/images/hr/logo/2025/clikkle%20hr.png"],
  },
  alternates: {
    canonical: "https://clikkle.com/hr",
  },
  icons: {
    icon: "https://cdn.clikkle.com/images/hr/logo/2025/clikkle%20hr.png",
    apple: "https://cdn.clikkle.com/images/hr/logo/2025/clikkle%20hr.png",
  },
};

export default function HrHome() {
  return <HrHomePage />;
}
