import { Metadata } from "next";
import FilesHomePage from "../../clikklepages/filesHome";

export const metadata: Metadata = {
  title: "Clikkle Files | File Management & Cloud Storage | Secure File Sharing",
  description:
    "Store, organize, and share files securely with Clikkle's file management system. Cloud storage, file sharing, document collaboration, and secure access controls for your business files.",
  keywords:
    "file management, cloud storage, file sharing, document collaboration, secure file storage, business file management, document organization, file access control",
  openGraph: {
    title: "Clikkle Files | File Management & Cloud Storage | Secure File Sharing",
    description:
      "Store and share files securely with Clikkle's file management system. Cloud storage and document collaboration for teams.",
    url: "https://clikkle.com/files",
    images: [
      {
        url: "https://cdn.clikkle.com/images/files/logo/2025/clikkle%20files.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle File Management Dashboard",
      },
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Clikkle Files | File Management & Cloud Storage | Secure File Sharing",
    description:
      "Store and share files securely with Clikkle's file management platform.",
    images: [
      "https://cdn.clikkle.com/images/files/logo/2025/clikkle%20files.png",
    ],
  },
  alternates: {
    canonical: "https://clikkle.com/files",
  },
  icons: {
    icon: "https://cdn.clikkle.com/images/files/logo/2025/clikkle%20files.png",
    apple: "https://cdn.clikkle.com/images/files/logo/2025/clikkle%20files.png",
  },
};

export default function FilesHome() {
  return <FilesHomePage />;
}
