import { Metadata } from "next";
import EsignHomePage from "../../clikklepages/esignHome";

export const metadata: Metadata = {
  title: "Clikle eSign | Digital Document Signing",
  description: "Sign documents digitally with Clikkle's e-signature software. Secure electronic signatures, document workflows, legally binding signatures, and streamlined approval processes for your business documents.",
  keywords: "e-signature software, digital signatures, electronic signature, document signing, digital document workflow, legally binding signatures, e-signature platform, document approval",
  openGraph: {
    title: "Clikle eSign | Digital Document Signing",
    description: "Sign documents digitally with Clikkle's secure e-signature software. Streamline your document approval processes.",
    url: "https://clikkle.com/esign",
    images: [
      {
        url: "https://cdn.clikkle.com/images/e-sign/logo/2025/clikkle%20esign.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle eSignature Dashboard",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Clikle eSign | Digital Document Signing",
    description: "Sign documents digitally with Clikkle's secure e-signature platform.",
    images: ["https://cdn.clikkle.com/images/e-sign/logo/2025/clikkle%20esign.png"],
  },
  alternates: {
    canonical: "https://clikkle.com/esign",
  },
    icons: {
    icon: "https://cdn.clikkle.com/images/e-sign/logo/2025/clikkle%20esign.png",
    apple:
      "https://cdn.clikkle.com/images/e-sign/logo/2025/clikkle%20esign.png",
  },
};

export default function EsignHome() {
  return <EsignHomePage />;
}