import { Metadata } from "next";
import CrewHomePage from "@/clikklepages/crewHome";

export const metadata: Metadata = {
  title: "Clikkle Crew | Video Meeting Platform | Smart Scheduling Tool",
  description:
    "Connect with anyone, anywhere using Clikkle Crew's video meeting platform. Enjoy HD video calls, smart scheduling, screen sharing, and team collaboration in one secure platform. Free video conferencing for teams of all sizes.",
  keywords:
    "video meeting platform, video conferencing, online meetings, team collaboration, smart scheduling, screen sharing, virtual meetings, remote team communication, video calls, meeting scheduler",
  openGraph: {
    title: "Clikkle Crew | Video Meeting Platform | Smart Scheduling Tool",
    description:
      "High-quality video meetings with intelligent scheduling. Connect with teams, clients, and partners from any device with Clikkle Crew.",
    url: "https://clikkle.com/crew",
    images: [
      {
        url: "https://cdn.clikkle.com/images/crew/logo/2025/Clikkle%20Crew.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle Crew Video Meeting Platform",
      },
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Clikkle Crew | Video Meeting Platform | Smart Scheduling Tool",
    description:
      "High-quality video meetings with intelligent scheduling. Connect with teams from any device.",
    images: [
      "https://cdn.clikkle.com/images/crew/logo/2025/Clikkle%20Crew.png",
    ],
  },
  alternates: {
    canonical: "https://clikkle.com/crew",
  },
  icons: {
    icon: "https://cdn.clikkle.com/images/crew/logo/2025/Clikkle%20Crew.png",
    apple: "https://cdn.clikkle.com/images/crew/logo/2025/Clikkle%20Crew.png",
  },
};

export default function CrewHome() {
  return <CrewHomePage />;
}
