import { Metadata } from "next";
import ContactComponent from "../../clikklepages/contact";

export const metadata: Metadata = {
  title: "Contact Clikkle | Business Suite Support & Sales",
  description: "Get in touch with Clikkle for sales inquiries, customer support, or general questions about our all-in-one business suite. Contact our team for demos, pricing, and assistance.",
  keywords: "contact clikkle, business suite support, sales inquiry, customer support, contact us, get in touch, clikkle help, business software support",
  openGraph: {
    title: "Contact Clikkle | Business Suite Support & Sales",
    description: "Get in touch with Clikkle for sales inquiries, customer support, or general questions about our all-in-one business suite.",
    url: "https://clikkle.com/contact",
    images: [
      {
        url: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
        width: 1200,
        height: 1200,
        alt: "Contact Clikkle - Support & Sales",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Contact Clikkle | Business Suite Support & Sales",
    description: "Get in touch with Clikkle for sales inquiries and customer support.",
    images: ["https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png"],
  },
  alternates: {
    canonical: "https://clikkle.com/contact",
  },
    icons: {
    icon: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
    apple:
      "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
  },
};

export default function ContactHome() {
  return <ContactComponent />;
}