import { Metadata } from "next";
import ComingSoon from "@/clikklepages/comingSoon";

export const metadata: Metadata = {
  title: "Clikkle Cmail | Business Email Management | Email Marketing Software",
  description: "Manage business emails effectively with Clikkle's email management software. Email marketing campaigns, newsletter creation, email automation, and comprehensive email analytics for better customer engagement.",
  keywords: "business email, email management, email marketing, newsletter software, email automation, email campaigns, email analytics, business email platform",
  openGraph: {
    title: "Clikkle Cmail | Business Email Management | Email Marketing Software",
    description: "Manage business emails effectively with Clikkle's email management software. Email marketing and newsletter creation.",
    url: "https://clikkle.com/cmail",
    images: [
      {
        url: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle Email Management Dashboard",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Clikkle Cmail | Business Email Management | Email Marketing Software",
    description: "Manage business emails effectively with Clikkle's email management platform.",
    images: ["https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png"],
  },
  alternates: {
    canonical: "https://clikkle.com/cmail",
  },
  icons: {
    icon: "https://cdn.clikkle.com/images/cmail/logo/2025/clikkle%20cmail.png",
    apple: "https://cdn.clikkle.com/images/cmail/logo/2025/clikkle%20cmail.png",
  },
};

export default function CmailHome() {
      return (
        <ComingSoon/>
    )
}