import { Metadata } from "next";
import ChatHomePage from "../../clikklepages/chatHome";

export const metadata: Metadata = {
  title:
    "Clikkle Chat | Team Chat & Communication Software | Business Messaging",
  description:
    "Enhance team communication with Clikkle's business chat software. Real-time messaging, team collaboration, file sharing, video calls, and secure business communication tools for modern teams.",
  keywords:
    "team chat software, business messaging, team communication, real-time chat, business collaboration, video calls, secure messaging, team messaging app",
  openGraph: {
    title:
      "Clikkle Chat | Team Chat & Communication Software | Business Messaging",
    description:
      "Enhance team communication with Clikkle's business chat software. Real-time messaging and collaboration tools.",
    url: "https://clikkle.com/chat",
    images: [
      {
        url: "https://cdn.clikkle.com/images/chat/logo/2025/clikkle%20chat.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle Team Chat Interface",
      },
    ],
  },
  twitter: {
    card: "summary_large_image",
    title:
      "Clikkle Chat | Team Chat & Communication Software | Business Messaging",
    description:
      "Enhance team communication with Clikkle's business chat platform.",
    images: [
      "https://cdn.clikkle.com/images/chat/logo/2025/clikkle%20chat.png",
    ],
  },
  alternates: {
    canonical: "https://clikkle.com/chat",
  },
  icons: {
    icon: "https://cdn.clikkle.com/images/chat/logo/2025/clikkle%20chat.png",
    apple: "https://cdn.clikkle.com/images/chat/logo/2025/clikkle%20chat.png",
  },
};

export default function ChatHome() {
  return <ChatHomePage />;
}
