import { Metadata } from "next";
import CampaignsHomeComponent from "../../clikklepages/campaignsHome";

export const metadata: Metadata = {
  title:
    "Clikkle Campaigns | Marketing Campaign Management Software | Campaign Tracking",
  description:
    "Manage marketing campaigns effectively with Clikkle's campaign management software. Track campaign performance, manage budgets, analyze ROI, and optimize your marketing efforts with comprehensive campaign tools.",
  keywords:
    "campaign management, marketing campaigns, campaign tracking, marketing automation, campaign analytics, ROI tracking, marketing tools, campaign optimization",
  openGraph: {
    title:
      "Clikkle Campaigns | Marketing Campaign Management Software | Campaign Tracking",
    description:
      "Manage marketing campaigns effectively with Clikkle's campaign management tools. Track performance and optimize ROI.",
    url: "https://clikkle.com/campaigns",
    images: [
      {
        url: "https://cdn.clikkle.com/images/campaigns/logo/2025/clikkle%20campaigns.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle Campaign Management Dashboard",
      },
    ],
  },
  twitter: {
    card: "summary_large_image",
    title:
      "Clikkle Campaigns | Marketing Campaign Management Software | Campaign Tracking",
    description:
      "Manage marketing campaigns effectively with Clikkle's campaign management tools.",
    images: [
      "https://cdn.clikkle.com/images/campaigns/logo/2025/clikkle%20campaigns.png",
    ],
  },
  alternates: {
    canonical: "https://clikkle.com/campaigns",
  },
  icons: {
    icon: "https://cdn.clikkle.com/images/campaigns/logo/2025/clikkle%20campaigns.png",
    apple:
      "https://cdn.clikkle.com/images/campaigns/logo/2025/clikkle%20campaigns.png",
  },
};

export default function CampaignsHome() {
  return <CampaignsHomeComponent />;
}
