import { Metadata } from "next";
import Calendar from "@/clikklepages/calendarHome";

export const metadata: Metadata = {
  title: "Clikkle Calendar | Business Calendar & Scheduling Software | Team Calendar",
  description: "Organize your business schedule with Clikkle's calendar software. Team scheduling, appointment booking, meeting management, and integrated calendar tools for better time management.",
  keywords: "business calendar, scheduling software, team calendar, appointment booking, meeting management, time management, calendar integration, scheduling tools",
  openGraph: {
    title: "Clikkle Calendar | Business Calendar & Scheduling Software | Team Calendar",
    description: "Organize your business schedule with Clikkle's calendar software. Team scheduling and appointment booking.",
    url: "https://clikkle.com/calendar",
    images: [
      {
        url: "https://cdn.clikkle.com/images/calendar/logo/2025/Clikkle%20Calendar.png",
        width: 1200,
        height: 1200,
        alt: "Clikkle Business Calendar Interface",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "Clikkle Calendar | Business Calendar & Scheduling Software | Team Calendar",
    description: "Organize your business schedule with Clikkle's calendar platform.",
    images: ["https://cdn.clikkle.com/images/calendar/logo/2025/Clikkle%20Calendar.png"],
  },
  alternates: {
    canonical: "https://clikkle.com/calendar",
  },
  icons: {
    icon: "https://cdn.clikkle.com/images/calendar/logo/2025/Clikkle%20Calendar.png",
    apple: "https://cdn.clikkle.com/images/calendar/logo/2025/Clikkle%20Calendar.png",
  },
};

export default function CalendarHome() {
    return (
        <Calendar/>
    )
}