import { Metadata } from "next";
import AboutUsComponent from "../../clikklepages/aboutUs";

export const metadata: Metadata = {
  title: "About Clikkle | All-in-One Business Suite Company",
  description: "Learn about Clikkle's mission to provide comprehensive business solutions. Discover our story, values, and commitment to helping businesses streamline operations with our all-in-one platform.",
  keywords: "about clikkle, company story, business suite company, our mission, company values, business software company, clikkle team",
  openGraph: {
    title: "About Clikkle | All-in-One Business Suite Company",
    description: "Learn about Clikkle's mission to provide comprehensive business solutions. Discover our story and values.",
    url: "https://clikkle.com/about",
    images: [
      {
        url: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
        width: 1200,
        height: 1200,
        alt: "About Clikkle - Company Information",
      }
    ],
  },
  twitter: {
    card: "summary_large_image",
    title: "About Clikkle | All-in-One Business Suite Company",
    description: "Learn about Clikkle's mission to provide comprehensive business solutions.",
    images: ["https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png"],
  },
  alternates: {
    canonical: "https://clikkle.com/about",
  },
  icons: {
    icon: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
    apple: "https://cdn.clikkle.com/images/worksuite/2025/clikkle%20worksuite.png",
  },
};

export default function AboutHome() {
  return <AboutUsComponent />;
}